/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine;

import ch.sahits.game.event.data.ClockTick;
import ch.sahits.game.event.data.ClockTickDayChange;
import ch.sahits.game.event.data.IClockTick;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.util.Timer;
import com.google.common.eventbus.AsyncEventBus;
import javafx.application.Platform;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class ClockTickTimer
extends Timer {
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    @Autowired
    private Date clock;
    @Autowired
    @Qualifier(value="serverEventBus")
    private AsyncEventBus serverEventBus;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    private static Object lock = new Object();

    public ClockTickTimer(long interval, long duration) {
        super(interval, duration);
    }

    protected void onTick() {
        this.tick();
        this.serverEventBus.post((Object)new IClockTick(){});
    }

    protected void onFinish() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        Object object = lock;
        synchronized (object) {
            int dayBefore = this.clock.getCurrentDate().getDayOfMonth();
            this.clock.updateTime(this.clock.getCurrentDate().plusMinutes(this.clock.getTickUpdate()));
            if (dayBefore != this.clock.getCurrentDate().getDayOfMonth()) {
                Platform.runLater(() -> this.clock.dayDateBinding().invalidate());
                ClockTickDayChange event = new ClockTickDayChange();
                this.clientServerEventBus.post((Object)event);
            }
        }
        this.clientServerEventBus.post((Object)new ClockTick());
    }
}

