/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.event.task;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.ship.EShipUpgrade;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.ship.impl.Ship;
import ch.sahits.game.openpatrician.model.ship.impl.ShipWeaponsLocationFactory;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
class RefitShipTask
extends TimedTask {
    private final IShip ship;
    private final EShipUpgrade level;
    protected final ICityPlayerProxyJFX city;
    @Autowired
    @XStreamOmitField
    private ShipWeaponsLocationFactory shipWeaponLocationFactory;
    @Autowired
    @Qualifier(value="clientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientEventBus;
    @Autowired
    @XStreamOmitField
    private Locale locale;
    @Autowired
    @XStreamOmitField
    @Qualifier(value="messageSource")
    private MessageSource messageSource;

    public RefitShipTask(DateTime executionTime, IShip ship, EShipUpgrade upgrade, ICityPlayerProxyJFX city) {
        this.setExecutionTime(executionTime);
        this.ship = ship;
        this.level = upgrade;
        this.city = city;
    }

    public void run() {
        while (this.ship.getShipUpgradeLevel() != this.level) {
            this.ship.upgrade();
            ((Ship)this.ship).setShipWeaponsLocation(this.shipWeaponLocationFactory.getShipWeaponsLocation(this.ship.getShipType(), this.level));
        }
        this.ship.setAvailable(true);
        this.city.getPlayersShips().add((Object)this.ship);
        if (this.city.getPlayersShips().size() == 1) {
            this.city.activateShip(this.ship);
        }
        int currentCapacity = this.ship.getCapacity();
        DisplayMessage msg = new DisplayMessage(this.messageSource.getMessage("ch.sahits.game.openpatrician.engine.event.task.RefitShipTask.message", new Object[]{this.ship.getShipType(), this.level, currentCapacity}, this.locale.getCurrentLocal()));
        this.clientEventBus.post((Object)msg);
    }
}

