/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.land.city;

import ch.sahits.game.event.data.ClockTick;
import ch.sahits.game.event.data.ClockTickIntervalChange;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.engine.AbstractEngine;
import ch.sahits.game.openpatrician.engine.land.city.AutomaticTradingEngine;
import ch.sahits.game.openpatrician.engine.land.city.ChurchEngine;
import ch.sahits.game.openpatrician.engine.land.city.CityHallEngine;
import ch.sahits.game.openpatrician.engine.land.city.LoanerEngine;
import ch.sahits.game.openpatrician.engine.land.city.ShipyardEngine;
import ch.sahits.game.openpatrician.engine.land.city.TavernEngine;
import ch.sahits.game.openpatrician.engine.player.PlayerEngine;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IGame;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.impl.CitiesState;
import ch.sahits.game.openpatrician.model.city.impl.CityState;
import ch.sahits.game.openpatrician.util.MapInitializedBean;
import ch.sahits.game.openpatrician.util.javafx.IJavaFXApplicationThreadExecution;
import com.google.common.collect.Lists;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy
@DependentInitialisation(value=MapInitializedBean.class)
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class CityEngine
extends AbstractEngine {
    @Autowired
    private Random rnd;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private ShipyardEngine shipyardEngine;
    private static final int WARE_UPDATES_MINUTES = 720;
    private int numberOfTicks;
    private int tickCounter = 0;
    private static final byte STOPPED = 0;
    private static final byte STARTED = 1;
    private byte state = 0;
    @Autowired
    private Date date;
    @Autowired
    private CitiesState citiesState;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @Qualifier(value="serverEventBus")
    private AsyncEventBus serverEventBus;
    @Autowired
    @Qualifier(value="javaFXApplicationThreadExecution")
    private IJavaFXApplicationThreadExecution threadExecutor;
    @Autowired
    private AutomaticTradingEngine automaticTradingEngine;
    @Autowired
    private LoanerEngine loanerEngine;
    @Autowired
    private CityHallEngine cityHallEngine;
    @Autowired
    private PlayerEngine playerEngine;
    @Autowired
    private ChurchEngine churchEngine;
    @Autowired
    private TavernEngine tavernEngine;

    @PostConstruct
    public void initialize() {
        this.numberOfTicks = 720 / this.date.getTickUpdate();
        this.clientServerEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregister() {
        this.clientServerEventBus.unregister((Object)this);
    }

    @Subscribe
    public void handleClockTickIntervallChange(ClockTickIntervalChange event) {
        this.numberOfTicks = event.getInterval() == 0 ? -1 : 720 / event.getInterval();
    }

    int getNumberOfTicks() {
        return this.numberOfTicks;
    }

    @Subscribe
    public void handleClockTicked(ClockTick event) {
        ++this.tickCounter;
        if (this.tickCounter == this.numberOfTicks && this.state == 1) {
            this.tickCounter = 0;
            this.threadExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    CityEngine.this.produceAndConsumeWares();
                }
            });
        }
    }

    private void produceAndConsumeWares() {
        for (CityState state : this.citiesState.getCityEngineStates()) {
            state.consumeWares();
            state.produceWares();
        }
    }

    private void addCity(ICity city) {
        CityState cityState = city.getCityState();
        this.tavernEngine.addCity(cityState.getTavernState(), city);
        this.loanerEngine.addNewLoaner(city);
        this.cityHallEngine.establishCityHall(city);
        this.churchEngine.establishChurch(city);
    }

    public void start(IGame game) {
        for (ICity city : game.getMap().getCities()) {
            this.addCity(city);
        }
        this.state = 1;
    }

    @Override
    public List<AbstractEngine> getChildren() {
        ArrayList engines = Lists.newArrayList();
        engines.add(this.tavernEngine);
        engines.add(this.shipyardEngine);
        engines.add(this.automaticTradingEngine);
        engines.add(this.loanerEngine);
        engines.add(this.cityHallEngine);
        engines.add(this.playerEngine);
        engines.add(this.churchEngine);
        return engines;
    }

    public ShipyardEngine getShipyardEngine() {
        return this.shipyardEngine;
    }

    public TavernEngine findTavernEngine() {
        return this.tavernEngine;
    }
}

