/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.land.city;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IMap;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.weapon.EWeapon;
import ch.sahits.game.openpatrician.model.weapon.IWeapon;
import org.springframework.beans.factory.annotation.Autowired;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class OutriggerService {
    @Autowired
    private Date date;
    @Autowired
    private IMap map;

    public int getRequiredWeaponStrength(ICity city) {
        double xLocation = city.getCoordinates().getX();
        double westwardFactor = 1.0 + (this.map.getDimension().getWidth() - xLocation) / this.map.getDimension().getWidth();
        int currentYear = this.date.getCurrentDate().getYear();
        if (currentYear <= 1200) {
            return (int)westwardFactor;
        }
        int from1200 = currentYear - 1200;
        double yearFactor = (double)from1200 * 6.0 / 200.0;
        return (int)(westwardFactor * yearFactor);
    }

    public int getWeeklyReund(ICity city) {
        double xLocation = city.getCoordinates().getX();
        double westwardFactor = 1.0 + (this.map.getDimension().getWidth() - xLocation) / this.map.getDimension().getWidth();
        int currentYear = this.date.getCurrentDate().getYear();
        if (currentYear <= 1200) {
            return (int)westwardFactor * 30;
        }
        int from1200 = currentYear - 1200;
        double yearFactor = (double)from1200 * 6.0 / 200.0;
        return (int)(westwardFactor * yearFactor) * 30;
    }

    public int calculateShipsWeaponsStrength(IShip ship) {
        int strength = 0;
        strength += ship.getWeaponAmount((IWeapon)EWeapon.BALLISTA_BIG) * 2;
        strength += ship.getWeaponAmount((IWeapon)EWeapon.TREBUCHET_BIG) * 2;
        strength += ship.getWeaponAmount((IWeapon)EWeapon.CANNON) * 2;
        strength += ship.getWeaponAmount((IWeapon)EWeapon.BOMBARD) * 2;
        strength += ship.getWeaponAmount((IWeapon)EWeapon.BALLISTA_SMALL);
        return strength += ship.getWeaponAmount((IWeapon)EWeapon.TREBUCHET_SMALL);
    }
}

