/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.land.city.internal;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.collections.SortedMapRandomizedSameElements;
import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.Election;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.util.OpenPatricianRandom;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.List;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class ElectionTask
extends TimedTask {
    @Autowired
    @XStreamOmitField
    private OpenPatricianRandom oprnd;
    private final SortedMapRandomizedSameElements candidateMap;
    private final Election result;

    public ElectionTask(SortedMapRandomizedSameElements candidateMap, Election result, DateTime electionTime) {
        this.candidateMap = candidateMap;
        this.result = result;
        this.setExecutionTime(electionTime);
    }

    public void run() {
        int index = this.oprnd.nextSlidingRandomDecreasing(this.candidateMap.size() - 1, 0.5);
        List citizens = this.candidateMap.getAtIndex(index);
        this.result.vote((ICitizen)citizens.get(0));
    }
}

