package ch.sahits.game.openpatrician.engine.player;

import ch.sahits.game.event.data.PeriodicalTimeDayUpdate;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.engine.AbstractEngine;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.PlayerList;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.impl.BalanceSheet;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.List;

/**
 * Base engine representing a player. If the player is AI the correseponding
 * engine will be a subclass of this engine.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Jun 16, 2015
 */
@LazySingleton
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class PlayerEngine extends AbstractEngine {
    @Autowired
    private PlayerList players;
    @Autowired
    @Qualifier("serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @PostConstruct
    private void init() {
        clientServerEventBus.register(this);
    }
    @PreDestroy
    private void unregister() {
        clientServerEventBus.unregister(this);
    }
    @Subscribe
    public void handleDailyUpdate(PeriodicalTimeDayUpdate event){
        dailyUpdateBalanceSheet();
    }



    @Override
    public List<AbstractEngine> getChildren() {
        return new ArrayList<>();
    }
    private void dailyUpdateBalanceSheet() {
        for (IPlayer player : players) {
            ICity city = player.getHometown();
            BalanceSheet sheet = (BalanceSheet) player.findTradingOffice(city).getCurrentWeek();
            sheet.handleDailyUpdate();
        }
    }
}
