package ch.sahits.game.openpatrician.spring;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.engine.ClockTickTimer;
import ch.sahits.game.openpatrician.util.MapInitializedBean;
import ch.sahits.game.openpatrician.util.StartNewGameBean;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

/**
 * Spring configuration for the engine module.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Feb 02, 2014
 */
@Configuration
@ComponentScan({"ch.sahits.game.openpatrician.engine",
                "ch.sahits.game.openpatrician.javafx.util"})
@ClassCategory(EClassCategory.STARTUP)
public class EngineConfiguration {
    @Bean
    public static PropertyPlaceholderConfigurer applicationServerProperties() {
        PropertyPlaceholderConfigurer bean = new PropertyPlaceholderConfigurer();
        bean.setIgnoreUnresolvablePlaceholders(true);
        bean.setLocations(new Resource[]{new ClassPathResource("model-settings.properties")});
        return bean;
    }

    @Bean
    @Scope("prototype")
    public StartNewGameBean startNewGameBean() {
        return new StartNewGameBean();
    }
    @Bean
    @Scope("prototype")
    public MapInitializedBean mapInitializedBean() {
        return new MapInitializedBean();
    }
    @Bean
    public ClockTickTimer clockTickTimer() {
        return new ClockTickTimer(100, ClockTickTimer.DURATION_INFINITY);
    }
}
