/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.collections.SortedMapRandomizedSameElements;
import ch.sahits.game.openpatrician.engine.land.city.internal.AddViolationTask;
import ch.sahits.game.openpatrician.engine.land.city.internal.CityWallBuildingTask;
import ch.sahits.game.openpatrician.engine.land.city.internal.CityWallMaterialBuyingTask;
import ch.sahits.game.openpatrician.engine.land.city.internal.ElectionTask;
import ch.sahits.game.openpatrician.engine.land.city.internal.VoteTask;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityHall;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityViolation;
import ch.sahits.game.openpatrician.model.city.cityhall.IEldermanOffice;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.Ballot;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.Election;
import ch.sahits.game.openpatrician.model.city.impl.CityWall;
import ch.sahits.game.openpatrician.util.StartNewGameBean;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy
@DependentInitialisation(value=StartNewGameBean.class)
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class EngineFactory {
    @Autowired
    private ApplicationContext context;

    public ElectionTask getNewElectionTask(SortedMapRandomizedSameElements candidates, Election result, DateTime executionTime) {
        return (ElectionTask)((Object)this.context.getBean("electionTask", new Object[]{candidates, result, executionTime}));
    }

    public VoteTask getVoteTask(boolean yes, DateTime executionTime, Ballot result) {
        return (VoteTask)((Object)this.context.getBean("voteTask", new Object[]{result, executionTime, yes}));
    }

    public CityWallBuildingTask getCityWallBuildingTask(CityWall cityWall, DateTime executionTime) {
        return (CityWallBuildingTask)((Object)this.context.getBean("cityWallBuildingTask", new Object[]{cityWall, executionTime}));
    }

    public CityWallMaterialBuyingTask getCityWallBuyMaterialTask(ICityHall cityHall, DateTime executionTime) {
        return (CityWallMaterialBuyingTask)((Object)this.context.getBean("cityWallMaterialBuyingTask", new Object[]{cityHall, executionTime}));
    }

    public AddViolationTask getViolationTask(ICityViolation violation, IEldermanOffice office, DateTime executionTime) {
        return (AddViolationTask)((Object)this.context.getBean("addViolationTask", new Object[]{violation, office, executionTime}));
    }
}

