/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.land.city;

import ch.sahits.game.event.data.PeriodicalTimeWeekEndUpdate;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.engine.AbstractEngine;
import ch.sahits.game.openpatrician.engine.EngineFactory;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.city.EChurchExtension;
import ch.sahits.game.openpatrician.model.city.IChurch;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.collection.CityChurchRegistry;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.model.factory.StateFactory;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class ChurchEngine
extends AbstractEngine {
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    private Random rnd;
    @Autowired
    private Date date;
    @Autowired
    private TimedUpdatableTaskList timedTaskListener;
    @Autowired
    private EngineFactory engineFactory;
    @Autowired
    private StateFactory stateFactory;
    @Autowired
    private CityChurchRegistry churchMap;

    @PostConstruct
    private void init() {
        this.clientServerEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregister() {
        this.clientServerEventBus.unregister((Object)this);
    }

    @Override
    public List<AbstractEngine> getChildren() {
        return Collections.EMPTY_LIST;
    }

    @Subscribe
    public void handleWeeklyUpdate(PeriodicalTimeWeekEndUpdate event) {
        for (ICity iCity : this.churchMap.keySet()) {
            final IChurch church = this.getChurch(iCity);
            if (!church.getExtensionLevel().getNextExtensionLevel().isPresent()) continue;
            EChurchExtension next = (EChurchExtension)church.getExtensionLevel().getNextExtensionLevel().get();
            int collectedDonationsForExtension = church.getCollectedDonationsForExtension();
            if (collectedDonationsForExtension < next.getRequiredCash()) continue;
            int delay = this.rnd.nextInt(30);
            final DateTime executionTime = this.date.getCurrentDate().plusDays(delay);
            TimedTask task = new TimedTask(){
                {
                    super.setExecutionTime(executionTime);
                }

                public void run() {
                    church.upgrade();
                }
            };
            this.timedTaskListener.add(task);
        }
    }

    public void establishChurch(ICity city) {
        IChurch church = this.stateFactory.createChurch();
        this.churchMap.put((Object)city, (Object)church);
    }

    public IChurch getChurch(ICity city) {
        return (IChurch)this.churchMap.get((Object)city);
    }
}

