/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.land.city;

import ch.sahits.game.event.data.ClockTickDayChange;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.engine.AbstractEngine;
import ch.sahits.game.openpatrician.engine.land.CaptainEngine;
import ch.sahits.game.openpatrician.model.IUpdatableCityRelatedState;
import ch.sahits.game.openpatrician.model.IUpdateableState;
import ch.sahits.game.openpatrician.model.city.EPopulationClass;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.impl.TavernState;
import ch.sahits.game.openpatrician.model.collection.CityTavernRegistry;
import ch.sahits.game.openpatrician.model.people.IPerson;
import ch.sahits.game.openpatrician.model.people.ISailorState;
import ch.sahits.game.openpatrician.model.people.ITavernPerson;
import ch.sahits.game.openpatrician.util.StartNewGameBean;
import com.google.common.collect.Lists;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy
@DependentInitialisation(value=StartNewGameBean.class)
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class TavernEngine
extends AbstractEngine {
    @Autowired
    private Random rnd;
    @Value(value="${beggar.salior.ratio}")
    private int beggarSailorRation;
    @Autowired
    private CaptainEngine captainEngine;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    private CityTavernRegistry cities;

    public void addCity(TavernState state, ICity city) {
        this.cities.put((Object)city, (Object)state);
        int nbSailors = this.computeNumbersOfSailors(city);
        ISailorState sailors = state.getSailors();
        sailors.setNumberOfSailors(nbSailors);
        this.handlePersonsBecomingAbsent(state);
        this.handlePersonsBecomingPresent(city, state);
    }

    @Override
    public List<AbstractEngine> getChildren() {
        return Lists.newArrayList((Object[])new AbstractEngine[]{this.captainEngine});
    }

    @PostConstruct
    private void init() {
        this.clientServerEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregister() {
        this.clientServerEventBus.unregister((Object)this);
    }

    private int computeNumbersOfSailors(ICity city) {
        int nbBeggars = city.getPopulation(EPopulationClass.BEGGAR);
        int nbSailors = (int)((double)(nbBeggars / this.beggarSailorRation) * this.rnd.nextDouble() * 2.0);
        return nbSailors;
    }

    @Subscribe
    public void handleDayChange(ClockTickDayChange event) {
        for (Map.Entry entry : this.cities.entrySet()) {
            ICity city = (ICity)entry.getKey();
            TavernState state = (TavernState)entry.getValue();
            int nbSailors = this.computeNumbersOfSailors(city);
            state.getSailors().setNumberOfSailors(nbSailors);
            this.handlePersonsBecomingAbsent(state);
            this.handlePersonsBecomingPresent(city, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePersonsBecomingAbsent(TavernState state) {
        ObservableList present = state.presentPersonsProperty();
        ArrayList leavingPersons = Lists.newArrayList();
        for (IPerson p : present) {
            if (!(p instanceof ITavernPerson)) continue;
            ITavernPerson person = (ITavernPerson)p;
            double maxPresence = Math.abs(person.getMaxDaysPresent());
            double presenceTime = Math.abs(person.getNumberOfDaysSinceArrival());
            double absence = this.rnd.nextDouble() * 2.0 * maxPresence / presenceTime;
            if (!(absence > 0.5)) continue;
            leavingPersons.add(person);
        }
        TavernState tavernState = state;
        synchronized (tavernState) {
            for (ITavernPerson person : leavingPersons) {
                person.leave();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePersonsBecomingPresent(ICity city, TavernState state) {
        ObservableList absent = state.absentPersonProperty();
        ArrayList arrivingPersons = Lists.newArrayList();
        for (ITavernPerson person : absent) {
            double maxPresence = Math.abs(person.getMaxDaysPresent());
            double maxNbAbsence = Math.abs(person.getMaxDaysAbsent());
            double absentTime = (double)person.getNumberOfDaysSinceArrival() - maxPresence;
            double presence = this.rnd.nextDouble() * 2.0 * (absentTime / maxNbAbsence);
            if (!(presence > 0.5)) continue;
            if (person instanceof IUpdateableState) {
                ((IUpdateableState)person).update();
            } else if (person instanceof IUpdatableCityRelatedState) {
                ((IUpdatableCityRelatedState)person).update(city);
            } else {
                throw new IllegalArgumentException("Person is not updatable: " + person);
            }
            arrivingPersons.add(person);
        }
        TavernState tavernState = state;
        synchronized (tavernState) {
            for (ITavernPerson person : arrivingPersons) {
                person.arrive();
            }
        }
    }

    public TavernState getTavernState(ICity city) {
        return (TavernState)this.cities.get((Object)city);
    }
}

