package ch.sahits.game.openpatrician.engine;

import java.util.List;

/**
 * This is the base class for all engine classes.
 * An engine dives a certain aspect of the game.
 * As everything is event driven through the AsyncEventBus
 * the engine will be triggered in a separate thread.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Jan 22, 2014
 */
public abstract class AbstractEngine {
    /**
     * Any engine may hold various child engines. This is the way to retrieve them.
     * If there are no child engines, return an empty list.
     * Subclasses have to implement this in the proper way.
     * @return list of child engines.
     */
    public abstract List<AbstractEngine> getChildren();
}
