package ch.sahits.game.openpatrician.engine.land;

import ch.sahits.game.event.data.ClockTickDayChange;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.engine.AbstractEngine;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.people.ICaptain;
import ch.sahits.game.openpatrician.model.people.impl.CaptainsState;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import java.util.List;
import java.util.Optional;

import static com.google.common.collect.Lists.newArrayList;

/**
 * Engine controling all the roaming captains.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 19, 2013
 *
 */
@LazySingleton
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class CaptainEngine extends AbstractEngine {
	@Autowired
	private Date date;
	@Autowired
	private CaptainsState captainsState;
    @Autowired
    @Qualifier("timerEventBus")
    private AsyncEventBus timerEventBus;


    @PostConstruct
	public void init() {
        timerEventBus.register(this);
	}
    @PreDestroy
    private void unregister() {
        timerEventBus.unregister(this);
    }
    @Subscribe
    public void handleDayChange(ClockTickDayChange event) {
        DateTime today = date.getCurrentDate();
        DateTime shouldLeaveWhenArrivedBefore = today.minusDays(captainsState.getMaxDaysPresent());
        for (ICaptain captain : captainsState.getAllFreeCaptains()) {
            Optional<ICity> city = captainsState.findCaptainsCurrentCity(captain);
            if (city.isPresent()) {
                DateTime arrival = captainsState.getArrivalDate(captain);
                if (arrival.isBefore(shouldLeaveWhenArrivedBefore)) {
                    captainsState.assignToOtherCity(city.get(), captain);
                }
            }
        }
    }

    @Override
    public List<AbstractEngine> getChildren() {
        return newArrayList();
    }

    // TODO remove captain from the list (retirement)
		// TODO add captain to the list if one was retired

}
