package ch.sahits.game.openpatrician.engine.sea;

import ch.sahits.game.openpatrician.clientserverinterface.service.PathInterpolator;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import javafx.geometry.Point2D;
import javafx.scene.shape.Path;

import java.util.List;

/**
 * Converts a list of point into a shape that can be used as path.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Jan 05, 2016
 */
public interface IPathConverter {
    /**
     * Create a path shape out of a list of points.
     * When the path is created the vessel will be added to the
     * TravellingVessels container.
     * @param vessel vessel that is traveling the path.
     * @param pointedPath input points.
     * @param scale scaling that is used on the path due to the sacle of the map.
     * @return shape representing a path.
     */
    Path createPath(INavigableVessel vessel, List<Point2D> pointedPath, double scale);
    /**
     * Reduce the number of points that are needed to describe the path.
     * @param initialPoints list of initial points
     * @return list of reduced points.
     */
    List<Point2D> reduceLinePoints(List<Point2D> initialPoints);
    /**
     * Calculate the duration of the travel in milliseconds in real time for the specified fraction of the total distance
     * @param vessel that is traveling
     * @param interpolator used to hold the path information
     * @param fraction value between [0,1]. 1 means that the whole distance is traveled.
     * @return real time duration of the travel in milliseconds.
     */
    long calculateDuration(INavigableVessel vessel, PathInterpolator interpolator, double fraction);
}
