/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.event.task;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.event.TargetedEvent;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
class RepairTask
extends TimedTask {
    @Autowired
    @XStreamOmitField
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @XStreamOmitField
    private Locale locale;
    @Autowired
    @XStreamOmitField
    @Qualifier(value="messageSource")
    private MessageSource messageSource;
    private final IShip ship;
    protected final ICityPlayerProxyJFX city;

    public RepairTask(DateTime executionTime, IShip ship, ICityPlayerProxyJFX city) {
        this.setExecutionTime(executionTime);
        this.ship = ship;
        this.city = city;
    }

    public void run() {
        this.ship.repair();
        this.ship.setAvailable(true);
        this.city.getPlayersShips().add((Object)this.ship);
        if (this.city.getPlayersShips().size() == 1) {
            this.city.activateShip((INavigableVessel)this.ship);
        }
        DisplayMessage msg = new DisplayMessage("ch.sahits.game.openpatrician.engine.event.task.RepairTask.message", new Object[]{this.ship.getName()});
        TargetedEvent displayMessage = new TargetedEvent((IHumanPlayer)this.ship.getOwner(), (Object)msg);
        this.clientServerEventBus.post((Object)displayMessage);
    }
}

