/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.land;

import ch.sahits.game.event.data.ClockTickDayChange;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.engine.AbstractEngine;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.people.ICaptain;
import ch.sahits.game.openpatrician.model.people.impl.CaptainsState;
import com.google.common.collect.Lists;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import java.util.List;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class CaptainEngine
extends AbstractEngine {
    @Autowired
    private Date date;
    @Autowired
    private CaptainsState captainsState;
    @Autowired
    @Qualifier(value="timerEventBus")
    private AsyncEventBus timerEventBus;

    @PostConstruct
    public void init() {
        this.timerEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregister() {
        this.timerEventBus.unregister((Object)this);
    }

    @Subscribe
    public void handleDayChange(ClockTickDayChange event) {
        DateTime today = this.date.getCurrentDate();
        DateTime shouldLeaveWhenArrivedBefore = today.minusDays(this.captainsState.getMaxDaysPresent());
        for (ICaptain captain : this.captainsState.getAllFreeCaptains()) {
            DateTime arrival;
            Optional city = this.captainsState.findCaptainsCurrentCity(captain);
            if (!city.isPresent() || !(arrival = this.captainsState.getArrivalDate(captain)).isBefore((ReadableInstant)shouldLeaveWhenArrivedBefore)) continue;
            this.captainsState.assignToOtherCity((ICity)city.get(), captain);
        }
    }

    @Override
    public List<AbstractEngine> getChildren() {
        return Lists.newArrayList();
    }
}

