/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player;

import ch.sahits.game.event.data.PeriodicalTimeDayUpdate;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.engine.AbstractEngine;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.PlayerList;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.impl.BalanceSheet;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class PlayerEngine
extends AbstractEngine {
    @Autowired
    private PlayerList players;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;

    @PostConstruct
    private void init() {
        this.clientServerEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregister() {
        this.clientServerEventBus.unregister((Object)this);
    }

    @Subscribe
    public void handleDailyUpdate(PeriodicalTimeDayUpdate event) {
        this.dailyUpdateBalanceSheet();
    }

    @Override
    public List<AbstractEngine> getChildren() {
        return new ArrayList<AbstractEngine>();
    }

    private void dailyUpdateBalanceSheet() {
        for (IPlayer player : this.players) {
            ICity city = player.getHometown();
            BalanceSheet sheet = (BalanceSheet)player.findTradingOffice(city).getCurrentWeek();
            sheet.handleDailyUpdate();
        }
    }
}

