/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.sea;

import ch.sahits.game.event.data.HeuristicGraphInitialisationComplete;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.MapType;
import ch.sahits.game.openpatrician.engine.sea.BaseGraphCalulationService;
import ch.sahits.game.openpatrician.model.city.ICity;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import javafx.geometry.Point2D;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
@Component
@Lazy
public class AStarHeuristicProvider
extends BaseGraphCalulationService {
    private final Logger logger = LogManager.getLogger(this.getClass());
    @Autowired
    @Qualifier(value="serverThreadPool")
    private Executor serverThreadPool;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    private final Object lock = new Object();
    @MapType(key=Point2D.class, value=Map.class)
    private final Map<Point2D, Map<Point2D, Double>> heuristicMap = new ConcurrentHashMap<Point2D, Map<Point2D, Double>>();
    private int width;
    private int height;

    @PostConstruct
    private void initialize() {
        try {
            this.initImage();
            this.serverThreadPool.execute(() -> this.createGraph());
        }
        catch (IOException e) {
            this.logger.error("Failed to create black and white image from the map", (Throwable)e);
        }
    }

    @Override
    @VisibleForTesting
    void initImage() throws IOException {
        super.initImage();
        this.width = this.mapImage.getWidth();
        this.height = this.mapImage.getHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void createGraph() {
        long timestamp = System.currentTimeMillis();
        Object object = this.lock;
        synchronized (object) {
            List cities = this.map.getCities();
            for (ICity city : cities) {
                Map<Point2D, Double> hueristicForTarget = this.calculateHeuristicForSource(city.getCoordinates(), cities);
                this.heuristicMap.put(city.getCoordinates(), hueristicForTarget);
            }
            for (int x = 0; x < this.width; x += 5) {
                for (int y = 0; y < this.height; y += 5) {
                    Point2D source = this.getPoint(x, y);
                    Map<Point2D, Double> hueristicForTarget = this.calculateHeuristicForSource(source, cities);
                    this.heuristicMap.put(source, hueristicForTarget);
                }
            }
        }
        long took = System.currentTimeMillis() - timestamp;
        this.logger.debug("Created heuristic for " + this.heuristicMap.size() + " sources connecting to " + this.heuristicMap.values().iterator().next().size() + " nodes taking " + took + "ms");
        this.clientServerEventBus.post((Object)new HeuristicGraphInitialisationComplete());
    }

    private Map<Point2D, Double> calculateHeuristicForSource(Point2D source, List<ICity> cities) {
        HashMap<Point2D, Double> distance = new HashMap<Point2D, Double>();
        for (ICity city : cities) {
            Point2D coordinates = city.getCoordinates();
            double dist = this.calculateWeight(source, coordinates);
            distance.put(coordinates, dist);
        }
        return distance;
    }

    @Override
    @VisibleForTesting
    protected double calculateWeight(Point2D from, Point2D to) {
        if (from.equals((Object)to)) {
            return 0.0;
        }
        double distance = from.distance(to);
        return distance;
    }

    public boolean heuristicForSourceAvailable(Point2D source) {
        return this.heuristicMap.containsKey(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Point2D, Map<Point2D, Double>> getHeuristic() {
        Object object = this.lock;
        synchronized (object) {
            return this.heuristicMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTargetNodeToHeuristic(Point2D target) {
        Preconditions.checkNotNull((Object)target, (Object)"The target node may not be null");
        Object object = this.lock;
        synchronized (object) {
            for (Map.Entry<Point2D, Map<Point2D, Double>> entry : this.heuristicMap.entrySet()) {
                if (entry.getValue().containsKey(target)) continue;
                Point2D source = entry.getKey();
                double dist = this.calculateWeight(source, target);
                entry.getValue().put(target, dist);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSourceNodeToHeuristic(Point2D source) {
        Preconditions.checkNotNull((Object)source, (Object)"The source node may not be null");
        if (!this.heuristicForSourceAvailable(source)) {
            Object object = this.lock;
            synchronized (object) {
                this.serverThreadPool.execute(() -> {
                    Map<Point2D, Double> hueristicForTarget = this.calculateHeuristicForSource(source, this.map.getCities());
                    this.heuristicMap.put(source, hueristicForTarget);
                });
            }
        }
    }
}

