/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.sea;

import ch.sahits.game.event.data.ShipPositionUpdateEvent;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ListType;
import ch.sahits.game.openpatrician.model.IMap;
import ch.sahits.game.openpatrician.model.sea.ILocationTracker;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import com.google.common.collect.Interner;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Point2D;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy
@ClassCategory(value={EClassCategory.SINGLETON_BEAN, EClassCategory.SERIALIZABLE_BEAN})
public class LocationTracker
implements ILocationTracker {
    @XStreamOmitField
    private final Logger logger = LogManager.getLogger(this.getClass());
    @Autowired
    private IMap map;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @XStreamOmitField
    protected Interner<Point2D> pointInterner;
    private int segmentWidth;
    @ListType(value=INavigableVessel.class)
    private List<WeakReference<INavigableVessel>>[] segments;

    @PostConstruct
    void initialize() {
        this.segmentWidth = (int)Math.rint(this.map.getDimension().getWidth()) / 10;
        this.segments = new List[10];
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = new ArrayList<WeakReference<INavigableVessel>>();
        }
        this.clientServerEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregister() {
        this.clientServerEventBus.unregister((Object)this);
    }

    private int calculateHorizontalIndex(Point2D location) {
        int index = (int)Math.floor(location.getX() / (double)this.segmentWidth);
        return index;
    }

    public void add(INavigableVessel ship) {
        int index = this.calculateHorizontalIndex(ship.getLocation());
        this.segments[index].add(new WeakReference<INavigableVessel>(ship));
    }

    public void remove(INavigableVessel ship) {
        int index = this.calculateHorizontalIndex(ship.getLocation());
        if (!this.segments[index].removeIf(wr -> ship.equals(wr.get()))) {
            this.logger.warn("The ship {} could not be found and removed in segment {}", new Object[]{ship, index});
        }
    }

    public List<INavigableVessel> getShipsInSegment(Point2D location) {
        int index = this.calculateHorizontalIndex(location);
        List<WeakReference<INavigableVessel>> references = this.segments[index];
        ArrayList<INavigableVessel> copyList = new ArrayList<INavigableVessel>();
        for (WeakReference<INavigableVessel> reference : references) {
            if (reference.get() == null) continue;
            copyList.add((INavigableVessel)reference.get());
        }
        return copyList;
    }

    public List<INavigableVessel> getShipsInSegments(Point2D location, int radius) {
        int index = this.calculateHorizontalIndex(location);
        Point2D locationBefore = (Point2D)this.pointInterner.intern((Object)new Point2D(location.getX() - (double)radius, location.getY()));
        int indexBefore = this.calculateHorizontalIndex(locationBefore);
        Point2D locationAfter = (Point2D)this.pointInterner.intern((Object)new Point2D(location.getX() + (double)radius, location.getY()));
        int indexAfter = this.calculateHorizontalIndex(locationAfter);
        ArrayList<INavigableVessel> list = new ArrayList<INavigableVessel>();
        if (indexBefore != index) {
            list.addAll(this.getShipsInSegment(locationBefore));
        }
        list.addAll(this.getShipsInSegment(location));
        if (indexAfter != index) {
            list.addAll(this.getShipsInSegment(locationAfter));
        }
        return list;
    }

    @Subscribe
    public void handleShipMove(ShipPositionUpdateEvent event) {
        int newIndex;
        int oldIndex;
        if (event.getFromLocation().getX() != event.getToLocation().getX() && (oldIndex = this.calculateHorizontalIndex(event.getFromLocation())) != (newIndex = this.calculateHorizontalIndex(event.getToLocation()))) {
            this.segments[oldIndex].removeIf(wr -> event.getShip().equals(wr.get()));
            this.segments[newIndex].add(new WeakReference<INavigableVessel>(event.getShip()));
        }
    }
}

