/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.sea;

import ch.sahits.datastructure.GenericPair;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.dialog.DialogTemplate;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.event.TargetedEvent;
import ch.sahits.game.openpatrician.model.people.ICaptain;
import ch.sahits.game.openpatrician.model.people.IShipOwner;
import ch.sahits.game.openpatrician.model.service.ShipService;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.ship.IShipGroup;
import ch.sahits.game.openpatrician.model.ship.ShipFactory;
import ch.sahits.game.openpatrician.model.weapon.EWeapon;
import ch.sahits.game.openpatrician.model.weapon.IWeapon;
import ch.sahits.game.openpatrician.util.StartNewGameBean;
import ch.sahits.game.openpatrician.util.model.Tristate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.eventbus.AsyncEventBus;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
@DependentInitialisation(value=StartNewGameBean.class)
public class SeaFightService {
    private static final int DAMAGE_PER_STRENGTH = 2;
    private static final double DEATH_TOLL_PER_DAMAGE = 0.2;
    @Autowired
    private ShipService shipStrenghtService;
    @Autowired
    private ShipFactory shipFactory;
    @Autowired
    private Random rnd;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;

    public void calculateOutcome(List<IShip> attackingShips, List<IShip> defendingShips) {
        List<GenericPair<List<IShip>, List<IShip>>> pairings = this.calculatePairing(attackingShips, defendingShips);
        ArrayList<IShip> sunkenDefendingShips = new ArrayList<IShip>();
        ArrayList<IShip> sunkenAttackingShips = new ArrayList<IShip>();
        ArrayList<IShip> capturedDefendingShips = new ArrayList<IShip>();
        ArrayList<IShip> capturedAttackingShips = new ArrayList<IShip>();
        IShipOwner attacker = attackingShips.get(0).getOwner();
        IShipOwner defender = defendingShips.get(0).getOwner();
        Iterator<GenericPair<List<IShip>, List<IShip>>> pairingIter = pairings.iterator();
        while (pairingIter.hasNext()) {
            GenericPair<List<IShip>, List<IShip>> pairing = pairingIter.next();
            boolean attackShipTurn = true;
            this.runAttackMove(pairings, sunkenDefendingShips, sunkenAttackingShips, capturedDefendingShips, capturedAttackingShips, pairingIter, pairing, attackShipTurn);
            if (pairings.size() <= 0) continue;
            attackShipTurn = false;
            this.runAttackMove(pairings, sunkenDefendingShips, sunkenAttackingShips, capturedDefendingShips, capturedAttackingShips, pairingIter, pairing, attackShipTurn);
        }
        Iterator iterator = capturedAttackingShips.iterator();
        while (iterator.hasNext()) {
            IShip ship = (IShip)iterator.next();
            if (!capturedDefendingShips.contains(ship)) continue;
            iterator.remove();
            capturedDefendingShips.remove(ship);
        }
        this.postMessage(attackingShips, defendingShips, sunkenDefendingShips, sunkenAttackingShips, capturedDefendingShips, capturedAttackingShips, attacker, defender);
    }

    @VisibleForTesting
    void postMessage(List<IShip> attackingShips, List<IShip> defendingShips, List<IShip> sunkenDefendingShips, List<IShip> sunkenAttackingShips, List<IShip> capturedDefendingShips, List<IShip> capturedAttackingShips, IShipOwner attacker, IShipOwner defender) {
        TargetedEvent tagetDisplayMsg;
        DisplayMessage message;
        DialogTemplate template;
        String lostShipName;
        String lostShipName2;
        String lastShipcaptured;
        String lastShipcaptured2;
        StringBuffer capturedShips;
        String lastShipSunk;
        StringBuffer sunkenShips;
        String lastShip;
        StringBuffer capturedShips2;
        Tristate tristate;
        int lostShips;
        Object[] args;
        String messageKey;
        String titleKey;
        if (attacker instanceof IHumanPlayer) {
            titleKey = "";
            messageKey = "";
            args = null;
            lostShips = sunkenAttackingShips.size() + capturedAttackingShips.size();
            tristate = lostShips == 0 ? Tristate.STATE_TWO : (lostShips == attackingShips.size() ? Tristate.STATE_ONE : Tristate.STATE_THREE);
            switch (tristate) {
                case STATE_ONE: {
                    titleKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.unsuccessfulAttackAttacker.title";
                    if (sunkenAttackingShips.size() == 1 && capturedAttackingShips.size() == 0) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.unsuccessful.sunkOneShip";
                        args = new Object[]{sunkenAttackingShips.get(0).getName(), defender.getName() + " " + defender.getLastName()};
                        break;
                    }
                    if (sunkenAttackingShips.size() == 0 && capturedAttackingShips.size() == 1) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.unsuccessful.capturedOneShip";
                        args = new Object[]{capturedAttackingShips.get(0).getName(), defender.getName() + " " + defender.getLastName()};
                        break;
                    }
                    if (sunkenAttackingShips.size() == 1 && capturedAttackingShips.size() == 1) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.unsuccessful.sunkAndCapturedOneShip";
                        args = new Object[]{sunkenAttackingShips.get(0).getName(), capturedAttackingShips.get(0).getName(), defender.getName() + " " + defender.getLastName()};
                        break;
                    }
                    if (sunkenAttackingShips.size() == 1 && capturedAttackingShips.size() > 1) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.unsuccessful.sunkOneAndCapturedMultipleShip";
                        capturedShips2 = this.getShipNameListWithoutTheLastShip(capturedAttackingShips);
                        lastShip = capturedAttackingShips.get(capturedAttackingShips.size() - 1).getName();
                        args = new Object[]{sunkenAttackingShips.get(0).getName(), capturedShips2.toString(), lastShip, defender.getName() + " " + defender.getLastName()};
                        break;
                    }
                    if (sunkenAttackingShips.size() == 0 && capturedAttackingShips.size() > 1) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.unsuccessful.capturedMultipleShip";
                        capturedShips2 = this.getShipNameListWithoutTheLastShip(capturedAttackingShips);
                        lastShip = capturedAttackingShips.get(capturedAttackingShips.size() - 1).getName();
                        args = new Object[]{capturedShips2.toString(), lastShip, defender.getName() + " " + defender.getLastName()};
                        break;
                    }
                    if (sunkenAttackingShips.size() > 1 && capturedAttackingShips.size() == 0) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.unsuccessful.sunkMultipleShip";
                        sunkenShips = this.getShipNameListWithoutTheLastShip(sunkenAttackingShips);
                        lastShip = sunkenAttackingShips.get(sunkenAttackingShips.size() - 1).getName();
                        args = new Object[]{sunkenShips.toString(), lastShip, defender.getName() + " " + defender.getLastName()};
                        break;
                    }
                    if (sunkenAttackingShips.size() > 1 && capturedAttackingShips.size() == 1) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.unsuccessful.capturedOneAndSunkMultipleShip";
                        sunkenShips = this.getShipNameListWithoutTheLastShip(sunkenAttackingShips);
                        lastShip = sunkenAttackingShips.get(sunkenAttackingShips.size() - 1).getName();
                        args = new Object[]{capturedAttackingShips.get(0).getName(), sunkenShips.toString(), lastShip, defender.getName() + " " + defender.getLastName()};
                        break;
                    }
                    messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.unsuccessful.capturedMultipleAndSunkMultipleShip";
                    sunkenShips = this.getShipNameListWithoutTheLastShip(sunkenAttackingShips);
                    lastShipSunk = sunkenAttackingShips.get(sunkenAttackingShips.size() - 1).getName();
                    capturedShips = this.getShipNameListWithoutTheLastShip(capturedAttackingShips);
                    lastShipcaptured2 = capturedAttackingShips.get(capturedAttackingShips.size() - 1).getName();
                    args = new Object[]{capturedShips.toString(), lastShipcaptured2, sunkenShips.toString(), lastShipSunk, defender.getName() + " " + defender.getLastName()};
                    break;
                }
                case STATE_TWO: {
                    titleKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.successfulAttackAttacker.title";
                    if (capturedDefendingShips.size() == 0 && sunkenDefendingShips.size() == 1) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.successful.sunkOneShip";
                        args = new Object[]{defender.getName() + " " + defender.getLastName()};
                        break;
                    }
                    if (capturedDefendingShips.size() == 1 && sunkenDefendingShips.size() == 0) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.successful.capturedOneShip";
                        args = new Object[]{capturedDefendingShips.get(0).getName(), defender.getName() + " " + defender.getLastName()};
                        break;
                    }
                    if (capturedDefendingShips.size() == 1 && sunkenDefendingShips.size() == 1) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.successful.sunkAndCapturedOneShip";
                        args = new Object[]{capturedDefendingShips.get(0).getName(), defender.getName() + " " + defender.getLastName()};
                        break;
                    }
                    if (capturedDefendingShips.size() == 0 && sunkenDefendingShips.size() > 1) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.successful.sunkMultipleShip";
                        args = new Object[]{sunkenDefendingShips.size(), defender.getName() + " " + defender.getLastName()};
                        break;
                    }
                    if (capturedDefendingShips.size() == 1 && sunkenDefendingShips.size() > 1) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.successful.capturedOneAndSunkMultipleShip";
                        args = new Object[]{sunkenDefendingShips.size(), capturedDefendingShips.get(0).getName(), defender.getName() + " " + defender.getLastName()};
                        break;
                    }
                    if (capturedDefendingShips.size() > 1 && sunkenDefendingShips.size() == 0) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.successful.capturedMultipleShip";
                        capturedShips2 = this.getShipNameListWithoutTheLastShip(capturedDefendingShips);
                        lastShipcaptured = capturedDefendingShips.get(capturedDefendingShips.size() - 1).getName();
                        args = new Object[]{capturedShips2.toString(), lastShipcaptured, defender.getName() + " " + defender.getLastName()};
                        break;
                    }
                    if (capturedDefendingShips.size() > 1 && sunkenDefendingShips.size() == 1) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.successful.sunkOneAndCapturedMultipleShip";
                        capturedShips2 = this.getShipNameListWithoutTheLastShip(capturedDefendingShips);
                        lastShipcaptured = capturedDefendingShips.get(capturedDefendingShips.size() - 1).getName();
                        args = new Object[]{capturedShips2.toString(), lastShipcaptured, defender.getName() + " " + defender.getLastName()};
                        break;
                    }
                    messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.successful.capturedMultipleAndSunkMultipleShip";
                    capturedShips2 = this.getShipNameListWithoutTheLastShip(capturedDefendingShips);
                    lastShipcaptured = capturedDefendingShips.get(capturedDefendingShips.size() - 1).getName();
                    args = new Object[]{sunkenDefendingShips.size(), capturedShips2.toString(), lastShipcaptured, defender.getName() + " " + defender.getLastName()};
                    break;
                }
                case STATE_THREE: {
                    titleKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.successfulAttackAttackerLosses.title";
                    if (capturedDefendingShips.size() == 0 && sunkenDefendingShips.size() == 1) {
                        if (lostShips == 1) {
                            messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.sunkOneShipLostShip";
                            lostShipName2 = this.getNameOfSingleLostShip(sunkenAttackingShips, capturedAttackingShips);
                            args = new Object[]{defender.getName() + " " + defender.getLastName(), lostShipName2};
                            break;
                        }
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.sunkOneShipLostShips";
                        args = new Object[]{defender.getName() + " " + defender.getLastName(), lostShips};
                        break;
                    }
                    if (capturedDefendingShips.size() == 1 && sunkenDefendingShips.size() == 0) {
                        if (lostShips == 1) {
                            messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.capturedOneShipLostShip";
                            lostShipName2 = this.getNameOfSingleLostShip(sunkenAttackingShips, capturedAttackingShips);
                            args = new Object[]{capturedDefendingShips.get(0).getName(), defender.getName() + " " + defender.getLastName(), lostShipName2};
                            break;
                        }
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.capturedOneShipLostShips";
                        args = new Object[]{capturedDefendingShips.get(0).getName(), defender.getName() + " " + defender.getLastName(), lostShips};
                        break;
                    }
                    if (capturedDefendingShips.size() == 1 && sunkenDefendingShips.size() == 1) {
                        if (lostShips == 1) {
                            messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.sunkAndCapturedOneShipLostShip";
                            lostShipName2 = this.getNameOfSingleLostShip(sunkenAttackingShips, capturedAttackingShips);
                            args = new Object[]{capturedDefendingShips.get(0).getName(), defender.getName() + " " + defender.getLastName(), lostShipName2};
                            break;
                        }
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.sunkAndCapturedOneShipLostShips";
                        args = new Object[]{capturedDefendingShips.get(0).getName(), defender.getName() + " " + defender.getLastName(), lostShips};
                        break;
                    }
                    if (capturedDefendingShips.size() == 0 && sunkenDefendingShips.size() > 1) {
                        if (lostShips == 1) {
                            messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.sunkMultipleShipLostShip";
                            lostShipName2 = this.getNameOfSingleLostShip(sunkenAttackingShips, capturedAttackingShips);
                            args = new Object[]{sunkenDefendingShips.size(), defender.getName() + " " + defender.getLastName(), lostShipName2};
                            break;
                        }
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.sunkMultipleShipLostShips";
                        args = new Object[]{sunkenDefendingShips.size(), defender.getName() + " " + defender.getLastName(), lostShips};
                        break;
                    }
                    if (capturedDefendingShips.size() == 1 && sunkenDefendingShips.size() > 1) {
                        if (lostShips == 1) {
                            messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.capturedOneAndSunkMultipleShipLostShip";
                            lostShipName2 = this.getNameOfSingleLostShip(sunkenAttackingShips, capturedAttackingShips);
                            args = new Object[]{sunkenDefendingShips.size(), capturedDefendingShips.get(0).getName(), defender.getName() + " " + defender.getLastName(), lostShipName2};
                            break;
                        }
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.capturedOneAndSunkMultipleShipLostShips";
                        args = new Object[]{sunkenDefendingShips.size(), capturedDefendingShips.get(0).getName(), defender.getName() + " " + defender.getLastName(), lostShips};
                        break;
                    }
                    if (capturedDefendingShips.size() > 1 && sunkenDefendingShips.size() == 0) {
                        capturedShips2 = this.getShipNameListWithoutTheLastShip(capturedDefendingShips);
                        lastShipcaptured = capturedDefendingShips.get(capturedDefendingShips.size() - 1).getName();
                        if (lostShips == 1) {
                            messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.capturedMultipleShipLostShip";
                            lostShipName = this.getNameOfSingleLostShip(sunkenAttackingShips, capturedAttackingShips);
                            args = new Object[]{capturedShips2.toString(), lastShipcaptured, defender.getName() + " " + defender.getLastName(), lostShipName};
                            break;
                        }
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.capturedMultipleShipLostShips";
                        args = new Object[]{capturedShips2.toString(), lastShipcaptured, defender.getName() + " " + defender.getLastName(), lostShips};
                        break;
                    }
                    if (capturedDefendingShips.size() > 1 && sunkenDefendingShips.size() == 1) {
                        capturedShips2 = this.getShipNameListWithoutTheLastShip(capturedDefendingShips);
                        lastShipcaptured = capturedDefendingShips.get(capturedDefendingShips.size() - 1).getName();
                        if (lostShips == 1) {
                            messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.sunkOneAndCapturedMultipleShipLostShip";
                            lostShipName = this.getNameOfSingleLostShip(sunkenAttackingShips, capturedAttackingShips);
                            args = new Object[]{capturedShips2.toString(), lastShipcaptured, defender.getName() + " " + defender.getLastName(), lostShipName};
                            break;
                        }
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.sunkOneAndCapturedMultipleShipLostShips";
                        args = new Object[]{capturedShips2.toString(), lastShipcaptured, defender.getName() + " " + defender.getLastName(), lostShips};
                        break;
                    }
                    capturedShips2 = this.getShipNameListWithoutTheLastShip(capturedDefendingShips);
                    lastShipcaptured = capturedDefendingShips.get(capturedDefendingShips.size() - 1).getName();
                    if (lostShips == 1) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.capturedMultipleAndSunkMultipleShipLostShip";
                        lostShipName = this.getNameOfSingleLostShip(sunkenAttackingShips, capturedAttackingShips);
                        args = new Object[]{sunkenDefendingShips.size(), capturedShips2.toString(), lastShipcaptured, defender.getName() + " " + defender.getLastName(), lostShipName};
                        break;
                    }
                    messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.capturedMultipleAndSunkMultipleShipLostShips";
                    args = new Object[]{sunkenDefendingShips.size(), capturedShips2.toString(), lastShipcaptured, defender.getName() + " " + defender.getLastName(), lostShips};
                }
            }
            template = DialogTemplate.builder().closable(true).titleKey(titleKey).messageKey(messageKey).messageArgs(args).build();
            message = new DisplayMessage(titleKey, template, new Object[0]);
            tagetDisplayMsg = new TargetedEvent((IHumanPlayer)attacker, (Object)message);
            this.clientServerEventBus.post((Object)tagetDisplayMsg);
        }
        if (defender instanceof IHumanPlayer) {
            titleKey = "";
            messageKey = "";
            args = null;
            lostShips = sunkenDefendingShips.size() + capturedDefendingShips.size();
            tristate = lostShips == 0 ? Tristate.STATE_TWO : (lostShips == defendingShips.size() ? Tristate.STATE_ONE : Tristate.STATE_THREE);
            switch (tristate) {
                case STATE_ONE: {
                    titleKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.successfulAttackDefender.title";
                    if (sunkenDefendingShips.size() == 1 && capturedDefendingShips.size() == 0) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.unsuccessful.sunkOneShip";
                        args = new Object[]{sunkenDefendingShips.get(0).getName(), attacker.getName() + " " + attacker.getLastName()};
                        break;
                    }
                    if (sunkenDefendingShips.size() == 0 && capturedDefendingShips.size() == 1) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.unsuccessful.capturedOneShip";
                        args = new Object[]{capturedDefendingShips.get(0).getName(), attacker.getName() + " " + attacker.getLastName()};
                        break;
                    }
                    if (sunkenDefendingShips.size() == 1 && capturedDefendingShips.size() == 1) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.unsuccessful.sunkAndCapturedOneShip";
                        args = new Object[]{sunkenDefendingShips.get(0).getName(), capturedDefendingShips.get(0).getName(), attacker.getName() + " " + attacker.getLastName()};
                        break;
                    }
                    if (sunkenDefendingShips.size() == 1 && capturedDefendingShips.size() > 1) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.unsuccessful.sunkOneAndCapturedMultipleShip";
                        capturedShips2 = this.getShipNameListWithoutTheLastShip(capturedDefendingShips);
                        lastShip = capturedDefendingShips.get(capturedDefendingShips.size() - 1).getName();
                        args = new Object[]{sunkenDefendingShips.get(0).getName(), capturedShips2.toString(), lastShip, attacker.getName() + " " + attacker.getLastName()};
                        break;
                    }
                    if (sunkenDefendingShips.size() == 0 && capturedDefendingShips.size() > 1) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.unsuccessful.capturedMultipleShip";
                        capturedShips2 = this.getShipNameListWithoutTheLastShip(capturedDefendingShips);
                        lastShip = capturedDefendingShips.get(capturedDefendingShips.size() - 1).getName();
                        args = new Object[]{capturedShips2.toString(), lastShip, attacker.getName() + " " + attacker.getLastName()};
                        break;
                    }
                    if (sunkenDefendingShips.size() > 1 && capturedDefendingShips.size() == 0) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.unsuccessful.sunkMultipleShip";
                        sunkenShips = this.getShipNameListWithoutTheLastShip(sunkenDefendingShips);
                        lastShip = sunkenDefendingShips.get(sunkenDefendingShips.size() - 1).getName();
                        args = new Object[]{sunkenShips.toString(), lastShip, attacker.getName() + " " + attacker.getLastName()};
                        break;
                    }
                    if (sunkenDefendingShips.size() > 1 && capturedDefendingShips.size() == 1) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.unsuccessful.capturedOneAndSunkMultipleShip";
                        sunkenShips = this.getShipNameListWithoutTheLastShip(sunkenDefendingShips);
                        lastShip = sunkenDefendingShips.get(sunkenDefendingShips.size() - 1).getName();
                        args = new Object[]{capturedDefendingShips.get(0).getName(), sunkenShips.toString(), lastShip, attacker.getName() + " " + attacker.getLastName()};
                        break;
                    }
                    messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.unsuccessful.capturedMultipleAndSunkMultipleShip";
                    sunkenShips = this.getShipNameListWithoutTheLastShip(sunkenDefendingShips);
                    lastShipSunk = sunkenDefendingShips.get(sunkenDefendingShips.size() - 1).getName();
                    capturedShips = this.getShipNameListWithoutTheLastShip(capturedDefendingShips);
                    lastShipcaptured2 = capturedDefendingShips.get(capturedDefendingShips.size() - 1).getName();
                    args = new Object[]{capturedShips.toString(), lastShipcaptured2, sunkenShips.toString(), lastShipSunk, attacker.getName() + " " + attacker.getLastName()};
                    break;
                }
                case STATE_TWO: {
                    titleKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.unsuccessfulAttackDefender.title";
                    if (capturedAttackingShips.size() == 0 && sunkenAttackingShips.size() == 1) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.successful.sunkOneShip";
                        args = new Object[]{attacker.getName() + " " + attacker.getLastName()};
                        break;
                    }
                    if (capturedAttackingShips.size() == 1 && sunkenAttackingShips.size() == 0) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.successful.capturedOneShip";
                        args = new Object[]{capturedAttackingShips.get(0).getName(), attacker.getName() + " " + attacker.getLastName()};
                        break;
                    }
                    if (capturedAttackingShips.size() == 1 && sunkenAttackingShips.size() == 1) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.successful.sunkAndCapturedOneShip";
                        args = new Object[]{capturedAttackingShips.get(0).getName(), attacker.getName() + " " + attacker.getLastName()};
                        break;
                    }
                    if (capturedAttackingShips.size() == 0 && sunkenAttackingShips.size() > 1) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.successful.sunkMultipleShip";
                        args = new Object[]{sunkenAttackingShips.size(), attacker.getName() + " " + attacker.getLastName()};
                        break;
                    }
                    if (capturedAttackingShips.size() == 1 && sunkenAttackingShips.size() > 1) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.successful.capturedOneAndSunkMultipleShip";
                        args = new Object[]{sunkenAttackingShips.size(), capturedAttackingShips.get(0).getName(), attacker.getName() + " " + attacker.getLastName()};
                        break;
                    }
                    if (capturedAttackingShips.size() > 1 && sunkenAttackingShips.size() == 0) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.successful.capturedMultipleShip";
                        capturedShips2 = this.getShipNameListWithoutTheLastShip(capturedAttackingShips);
                        lastShipcaptured = capturedAttackingShips.get(capturedAttackingShips.size() - 1).getName();
                        args = new Object[]{capturedShips2.toString(), lastShipcaptured, attacker.getName() + " " + attacker.getLastName()};
                        break;
                    }
                    if (capturedAttackingShips.size() > 1 && sunkenAttackingShips.size() == 1) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.successful.sunkOneAndCapturedMultipleShip";
                        capturedShips2 = this.getShipNameListWithoutTheLastShip(capturedAttackingShips);
                        lastShipcaptured = capturedAttackingShips.get(capturedAttackingShips.size() - 1).getName();
                        args = new Object[]{capturedShips2.toString(), lastShipcaptured, attacker.getName() + " " + attacker.getLastName()};
                        break;
                    }
                    messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.successful.capturedMultipleAndSunkMultipleShip";
                    capturedShips2 = this.getShipNameListWithoutTheLastShip(capturedAttackingShips);
                    lastShipcaptured = capturedAttackingShips.get(capturedAttackingShips.size() - 1).getName();
                    args = new Object[]{sunkenAttackingShips.size(), capturedShips2.toString(), lastShipcaptured, attacker.getName() + " " + attacker.getLastName()};
                    break;
                }
                case STATE_THREE: {
                    titleKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.unsuccessfulAttackDefenderLosses.title";
                    if (capturedAttackingShips.size() == 0 && sunkenAttackingShips.size() == 1) {
                        if (lostShips == 1) {
                            messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.sunkOneShipLostShip";
                            lostShipName2 = this.getNameOfSingleLostShip(sunkenDefendingShips, capturedDefendingShips);
                            args = new Object[]{attacker.getName() + " " + attacker.getLastName(), lostShipName2};
                            break;
                        }
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.sunkOneShipLostShips";
                        args = new Object[]{attacker.getName() + " " + attacker.getLastName(), lostShips};
                        break;
                    }
                    if (capturedAttackingShips.size() == 1 && sunkenAttackingShips.size() == 0) {
                        if (lostShips == 1) {
                            messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.capturedOneShipLostShip";
                            lostShipName2 = this.getNameOfSingleLostShip(sunkenDefendingShips, capturedDefendingShips);
                            args = new Object[]{capturedAttackingShips.get(0).getName(), attacker.getName() + " " + attacker.getLastName(), lostShipName2};
                            break;
                        }
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.capturedOneShipLostShips";
                        args = new Object[]{capturedAttackingShips.get(0).getName(), attacker.getName() + " " + attacker.getLastName(), lostShips};
                        break;
                    }
                    if (capturedAttackingShips.size() == 1 && sunkenAttackingShips.size() == 1) {
                        if (lostShips == 1) {
                            messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.sunkAndCapturedOneShipLostShip";
                            lostShipName2 = this.getNameOfSingleLostShip(sunkenDefendingShips, capturedDefendingShips);
                            args = new Object[]{capturedAttackingShips.get(0).getName(), attacker.getName() + " " + attacker.getLastName(), lostShipName2};
                            break;
                        }
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.sunkAndCapturedOneShipLostShips";
                        args = new Object[]{capturedAttackingShips.get(0).getName(), attacker.getName() + " " + attacker.getLastName(), lostShips};
                        break;
                    }
                    if (capturedAttackingShips.size() == 0 && sunkenAttackingShips.size() > 1) {
                        if (lostShips == 1) {
                            messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.sunkMultipleShipLostShip";
                            lostShipName2 = this.getNameOfSingleLostShip(sunkenDefendingShips, capturedDefendingShips);
                            args = new Object[]{sunkenAttackingShips.size(), attacker.getName() + " " + attacker.getLastName(), lostShipName2};
                            break;
                        }
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.sunkMultipleShipLostShips";
                        args = new Object[]{sunkenAttackingShips.size(), attacker.getName() + " " + attacker.getLastName(), lostShips};
                        break;
                    }
                    if (capturedAttackingShips.size() == 1 && sunkenAttackingShips.size() > 1) {
                        if (lostShips == 1) {
                            messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.capturedOneAndSunkMultipleShipLostShip";
                            lostShipName2 = this.getNameOfSingleLostShip(sunkenDefendingShips, capturedDefendingShips);
                            args = new Object[]{sunkenAttackingShips.size(), capturedAttackingShips.get(0).getName(), attacker.getName() + " " + attacker.getLastName(), lostShipName2};
                            break;
                        }
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.capturedOneAndSunkMultipleShipLostShips";
                        args = new Object[]{sunkenAttackingShips.size(), capturedAttackingShips.get(0).getName(), attacker.getName() + " " + attacker.getLastName(), lostShips};
                        break;
                    }
                    if (capturedAttackingShips.size() > 1 && sunkenAttackingShips.size() == 0) {
                        capturedShips2 = this.getShipNameListWithoutTheLastShip(capturedAttackingShips);
                        lastShipcaptured = capturedAttackingShips.get(capturedAttackingShips.size() - 1).getName();
                        if (lostShips == 1) {
                            messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.capturedMultipleShipLostShip";
                            lostShipName = this.getNameOfSingleLostShip(sunkenDefendingShips, capturedDefendingShips);
                            args = new Object[]{capturedShips2.toString(), lastShipcaptured, attacker.getName() + " " + attacker.getLastName(), lostShipName};
                            break;
                        }
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.capturedMultipleShipLostShips";
                        args = new Object[]{capturedShips2.toString(), lastShipcaptured, attacker.getName() + " " + attacker.getLastName(), lostShips};
                        break;
                    }
                    if (capturedAttackingShips.size() > 1 && sunkenAttackingShips.size() == 1) {
                        capturedShips2 = this.getShipNameListWithoutTheLastShip(capturedAttackingShips);
                        lastShipcaptured = capturedAttackingShips.get(capturedAttackingShips.size() - 1).getName();
                        if (lostShips == 1) {
                            messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.sunkOneAndCapturedMultipleShipLostShip";
                            lostShipName = this.getNameOfSingleLostShip(sunkenDefendingShips, capturedDefendingShips);
                            args = new Object[]{capturedShips2.toString(), lastShipcaptured, attacker.getName() + " " + attacker.getLastName(), lostShipName};
                            break;
                        }
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.sunkOneAndCapturedMultipleShipLostShips";
                        args = new Object[]{capturedShips2.toString(), lastShipcaptured, attacker.getName() + " " + attacker.getLastName(), lostShips};
                        break;
                    }
                    capturedShips2 = this.getShipNameListWithoutTheLastShip(capturedAttackingShips);
                    lastShipcaptured = capturedAttackingShips.get(capturedAttackingShips.size() - 1).getName();
                    if (lostShips == 1) {
                        messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.capturedMultipleAndSunkMultipleShipLostShip";
                        lostShipName = this.getNameOfSingleLostShip(sunkenDefendingShips, capturedDefendingShips);
                        args = new Object[]{sunkenAttackingShips.size(), capturedShips2.toString(), lastShipcaptured, attacker.getName() + " " + attacker.getLastName(), lostShipName};
                        break;
                    }
                    messageKey = "ch.sahits.game.openpatrician.engine.sea.SeaFightService.partialsuccessful.capturedMultipleAndSunkMultipleShipLostShips";
                    args = new Object[]{sunkenAttackingShips.size(), capturedShips2.toString(), lastShipcaptured, attacker.getName() + " " + attacker.getLastName(), lostShips};
                }
            }
            template = DialogTemplate.builder().closable(true).titleKey(titleKey).messageKey(messageKey).messageArgs(args).build();
            message = new DisplayMessage(titleKey, template, new Object[0]);
            tagetDisplayMsg = new TargetedEvent((IHumanPlayer)defender, (Object)message);
            this.clientServerEventBus.post((Object)tagetDisplayMsg);
        }
    }

    @VisibleForTesting
    StringBuffer getShipNameListWithoutTheLastShip(List<IShip> shipList) {
        StringBuffer sunkenShips = new StringBuffer();
        for (int i = 0; i < shipList.size() - 1; ++i) {
            IShip ship = shipList.get(i);
            sunkenShips.append(ship.getName());
            if (i >= shipList.size() - 2) continue;
            sunkenShips.append(", ");
        }
        return sunkenShips;
    }

    private String getNameOfSingleLostShip(List<IShip> sunkenAttackingShips, List<IShip> capturedAttackingShips) {
        return capturedAttackingShips.size() == 1 ? capturedAttackingShips.get(0).getName() : sunkenAttackingShips.get(0).getName();
    }

    private void runAttackMove(List<GenericPair<List<IShip>, List<IShip>>> pairings, List<IShip> sunkenDefendingShips, List<IShip> sunkenAttackingShips, List<IShip> capturedDefendingShips, List<IShip> capturedAttackingShips, Iterator<GenericPair<List<IShip>, List<IShip>>> pairingIter, GenericPair<List<IShip>, List<IShip>> pairing, boolean attackShipTurn) {
        List shipsNotOnTurn;
        List shipsOnTurn;
        if (attackShipTurn) {
            shipsOnTurn = (List)pairing.getFirst();
            shipsNotOnTurn = (List)pairing.getSecond();
        } else {
            shipsOnTurn = (List)pairing.getSecond();
            shipsNotOnTurn = (List)pairing.getFirst();
        }
        int strength = this.calculateStrength(shipsOnTurn);
        int agilityOnTurn = this.calculateAgility(shipsOnTurn);
        int agilityNotOnTurn = this.calculateAgility(shipsNotOnTurn);
        double evasionProbability = this.calculateEvasionProbability(agilityOnTurn, agilityNotOnTurn);
        double accuracy = this.calculateAccuracy(shipsOnTurn);
        int damage = this.calculateDamage(strength, accuracy, evasionProbability);
        int damagePerShip = damage / shipsNotOnTurn.size();
        int damageFirstShip = damagePerShip + damage % shipsNotOnTurn.size();
        ((IShip)shipsNotOnTurn.get(0)).damage(damageFirstShip);
        for (int i = 1; i < shipsNotOnTurn.size(); ++i) {
            ((IShip)shipsNotOnTurn.get(i)).damage(damagePerShip);
        }
        Iterator iterator = shipsNotOnTurn.iterator();
        while (iterator.hasNext()) {
            IShip ship = (IShip)iterator.next();
            if (ship.getDamage() != 0) continue;
            if (attackShipTurn) {
                sunkenDefendingShips.add(ship);
            } else {
                sunkenAttackingShips.add(ship);
            }
            iterator.remove();
            this.removeFromFleet(ship, ship.getOwner());
        }
        if (shipsNotOnTurn.isEmpty()) {
            pairingIter.remove();
            if (pairings.size() > 0) {
                this.redistributeShips(pairings, attackShipTurn, shipsOnTurn);
            }
        } else {
            int deathToll = this.calculateDeathToll(shipsNotOnTurn, damage);
            int deathTollPerShip = deathToll / shipsNotOnTurn.size();
            int deathTollFirstShip = deathTollPerShip + deathToll % shipsNotOnTurn.size();
            ((IShip)shipsNotOnTurn.get(0)).setNumberOfSailors(((IShip)shipsNotOnTurn.get(0)).getNumberOfSailors() - deathTollFirstShip);
            for (int i = 1; i < shipsNotOnTurn.size(); ++i) {
                ((IShip)shipsNotOnTurn.get(i)).setNumberOfSailors(((IShip)shipsNotOnTurn.get(i)).getNumberOfSailors() - deathTollPerShip);
            }
            IShip shipWithMaxSailors = this.findMaxSailorsOnShip(shipsOnTurn);
            IShip captureShip = null;
            for (IShip ship : shipsNotOnTurn) {
                if (ship.getNumberOfSailors() + 5 >= shipWithMaxSailors.getNumberOfSailors()) continue;
                captureShip = ship;
                break;
            }
            this.updateCapturedShip(capturedDefendingShips, capturedAttackingShips, attackShipTurn, shipWithMaxSailors, captureShip);
            if (shipsNotOnTurn.isEmpty()) {
                pairingIter.remove();
                this.redistributeShips(pairings, attackShipTurn, shipsOnTurn);
            } else if (shipsOnTurn.isEmpty()) {
                pairingIter.remove();
                this.redistributeShips(pairings, !attackShipTurn, shipsNotOnTurn);
            }
        }
    }

    private void redistributeShips(List<GenericPair<List<IShip>, List<IShip>>> pairings, boolean attackShipTurn, List<IShip> survivingShips) {
        for (IShip ship : survivingShips) {
            GenericPair<List<IShip>, List<IShip>> weakestPairing = this.findWeakest(pairings, attackShipTurn);
            if (attackShipTurn) {
                ((List)weakestPairing.getFirst()).add(ship);
                continue;
            }
            ((List)weakestPairing.getSecond()).add(ship);
        }
    }

    @VisibleForTesting
    void updateCapturedShip(List<IShip> capturedDefendingShips, List<IShip> capturedAttackingShips, boolean attackShipTurn, IShip shipWithMaxSailors, IShip captureShip) {
        if (captureShip != null) {
            int calculateCaptureSailors = this.captureShip(shipWithMaxSailors, captureShip);
            if (calculateCaptureSailors < 0) {
                int numberOfSailors = captureShip.getNumberOfSailors();
                int halfTheSailors = numberOfSailors / 2;
                captureShip.setNumberOfSailors(numberOfSailors - halfTheSailors);
                IShipOwner previousOwner = shipWithMaxSailors.getOwner();
                this.removeFromFleet(shipWithMaxSailors, previousOwner);
                shipWithMaxSailors.setNumberOfSailors(halfTheSailors);
                shipWithMaxSailors.setOwner(captureShip.getOwner());
                this.addToFleet(shipWithMaxSailors, captureShip.getOwner());
                if (attackShipTurn) {
                    capturedAttackingShips.add(shipWithMaxSailors);
                } else {
                    capturedDefendingShips.add(shipWithMaxSailors);
                }
            } else {
                int numberOfSailors = shipWithMaxSailors.getNumberOfSailors();
                int halfTheSailors = numberOfSailors / 2;
                shipWithMaxSailors.setNumberOfSailors(numberOfSailors - halfTheSailors);
                IShipOwner previousOwner = captureShip.getOwner();
                this.removeFromFleet(captureShip, previousOwner);
                captureShip.setNumberOfSailors(halfTheSailors);
                captureShip.setOwner(shipWithMaxSailors.getOwner());
                this.addToFleet(captureShip, shipWithMaxSailors.getOwner());
                if (attackShipTurn) {
                    capturedDefendingShips.add(captureShip);
                } else {
                    capturedAttackingShips.add(captureShip);
                }
            }
        }
    }

    private void addToFleet(IShip ship, IShipOwner owner) {
        if (owner instanceof IPlayer) {
            ((IPlayer)owner).getFleet().add(ship);
        }
    }

    private void removeFromFleet(IShip ship, IShipOwner owner) {
        if (owner instanceof IPlayer) {
            ((IPlayer)owner).getFleet().remove(ship);
        }
    }

    @VisibleForTesting
    int captureShip(IShip attackingShip, IShip defendingShip) {
        int attackingHandWeapon = attackingShip.getWeaponAmount((IWeapon)EWeapon.HAND_WEAPON);
        int defendingHandWeapon = defendingShip.getWeaponAmount((IWeapon)EWeapon.HAND_WEAPON);
        while (attackingShip.getNumberOfSailors() > 0 && defendingShip.getNumberOfSailors() > 0) {
            int nbSailors;
            int attackForce = attackingShip.getNumberOfSailors() + attackingHandWeapon;
            int defendForce = defendingShip.getNumberOfSailors() + defendingHandWeapon;
            double propSurvivingAttack = Math.min(Math.abs(this.rnd.nextGaussian()), 1.0);
            if (propSurvivingAttack > 0.8) {
                if (attackForce > defendForce) {
                    nbSailors = attackingShip.getNumberOfSailors() - 1;
                    attackingShip.setNumberOfSailors(nbSailors);
                    continue;
                }
                nbSailors = defendingShip.getNumberOfSailors() - 1;
                defendingShip.setNumberOfSailors(nbSailors);
                continue;
            }
            if (propSurvivingAttack > 0.5) continue;
            if (attackForce > defendForce) {
                nbSailors = defendingShip.getNumberOfSailors() - 1;
                defendingShip.setNumberOfSailors(nbSailors);
                continue;
            }
            nbSailors = attackingShip.getNumberOfSailors() - 1;
            attackingShip.setNumberOfSailors(nbSailors);
        }
        if (attackingShip.getNumberOfSailors() > 0) {
            return attackingShip.getNumberOfSailors();
        }
        return -defendingShip.getNumberOfSailors();
    }

    @VisibleForTesting
    IShip findMaxSailorsOnShip(List<IShip> ships) {
        int maxSailors = ships.get(0).getNumberOfSailors();
        IShip maxSailorShip = ships.get(0);
        for (int i = 1; i < ships.size(); ++i) {
            if (ships.get(i).getNumberOfSailors() <= maxSailors) continue;
            maxSailorShip = ships.get(i);
            maxSailors = ships.get(i).getNumberOfSailors();
        }
        return maxSailorShip;
    }

    @VisibleForTesting
    int calculateDeathToll(List<IShip> shipsNotOnTurn, int damage) {
        double nbDeath = (double)damage * 0.2 * (this.rnd.nextGaussian() + 1.0);
        int totalSailors = 0;
        for (IShip ship : shipsNotOnTurn) {
            totalSailors += ship.getNumberOfSailors();
        }
        return (int)Math.rint(Math.min((double)totalSailors, nbDeath));
    }

    @VisibleForTesting
    int calculateDamage(int strength, double accuracy, double evasionProbability) {
        int possibleDamage = strength * 2;
        double damage = (double)possibleDamage * accuracy;
        double evasion = this.rnd.nextDouble();
        if (evasion < evasionProbability) {
            return 0;
        }
        return (int)Math.rint(damage * evasionProbability * 1.5);
    }

    @VisibleForTesting
    double calculateAccuracy(List<IShip> shipsOnTurn) {
        double accuracy = 0.7;
        double captainAccuracy = 0.0;
        int nbCaptains = 0;
        for (IShip ship : shipsOnTurn) {
            if (!ship.getCaptian().isPresent()) continue;
            ++nbCaptains;
            captainAccuracy += (double)((ICaptain)ship.getCaptian().get()).getFightSkillLevel();
        }
        if (nbCaptains > 0) {
            captainAccuracy /= (double)nbCaptains * 10.0;
        }
        return accuracy + captainAccuracy;
    }

    @VisibleForTesting
    double calculateEvasionProbability(int attackingAgility, int defendingAgility) {
        if (defendingAgility < attackingAgility) {
            return 0.0;
        }
        if (defendingAgility == attackingAgility) {
            return 0.2;
        }
        return (double)(defendingAgility - attackingAgility) / 12.0 + 0.2;
    }

    private int calculateAgility(List<IShip> ships) {
        int agility = 0;
        for (IShip ship : ships) {
            agility += this.calculateAgility(ship);
        }
        return agility;
    }

    @VisibleForTesting
    int calculateAgility(IShip ship) {
        int agility = this.shipFactory.getShipSpeed(ship.getShipType());
        if (ship.getCaptian().isPresent()) {
            ICaptain captain = (ICaptain)ship.getCaptian().get();
            agility += (int)Math.rint((double)captain.getNavigationSkillLevel() * 0.7);
        }
        return agility;
    }

    @VisibleForTesting
    List<GenericPair<List<IShip>, List<IShip>>> calculatePairing(List<IShip> attackingShips, List<IShip> defendingShips) {
        int i;
        ArrayList<GenericPair<List<IShip>, List<IShip>>> pairings = new ArrayList<GenericPair<List<IShip>, List<IShip>>>();
        if (attackingShips.size() == defendingShips.size()) {
            for (int i2 = 0; i2 < attackingShips.size(); ++i2) {
                this.addPairing(attackingShips, defendingShips, pairings, i2);
            }
            return pairings;
        }
        int minSize = Math.min(attackingShips.size(), defendingShips.size());
        for (i = 0; i < minSize; ++i) {
            this.addPairing(attackingShips, defendingShips, pairings, i);
        }
        if (attackingShips.size() < defendingShips.size()) {
            for (i = minSize; i < defendingShips.size(); ++i) {
                GenericPair<List<IShip>, List<IShip>> weakestDefendingPair = this.findWeakest(pairings, false);
                ((List)weakestDefendingPair.getSecond()).add(defendingShips.get(i));
            }
        } else {
            for (i = minSize; i < attackingShips.size(); ++i) {
                GenericPair<List<IShip>, List<IShip>> weakestDefendingPair = this.findWeakest(pairings, true);
                ((List)weakestDefendingPair.getFirst()).add(attackingShips.get(i));
            }
        }
        return pairings;
    }

    @VisibleForTesting
    GenericPair<List<IShip>, List<IShip>> findWeakest(List<GenericPair<List<IShip>, List<IShip>>> parings, boolean lookInAttackingShips) {
        int minStrength = Integer.MAX_VALUE;
        int minStrengthIndex = 0;
        for (int i = 0; i < parings.size(); ++i) {
            GenericPair<List<IShip>, List<IShip>> paring = parings.get(i);
            List ships = lookInAttackingShips ? (List)paring.getFirst() : (List)paring.getSecond();
            int strength = 0;
            for (IShip ship : ships) {
                strength += this.calculateShipStrength(ship);
            }
            if (strength >= minStrength) continue;
            minStrength = strength;
            minStrengthIndex = i;
        }
        return parings.get(minStrengthIndex);
    }

    private int calculateStrength(List<IShip> ships) {
        int strength = 0;
        for (IShip ship : ships) {
            strength += this.calculateShipStrength(ship);
        }
        return strength;
    }

    @VisibleForTesting
    int calculateShipStrength(IShip ship) {
        int strength = this.shipStrenghtService.calculateShipsWeaponsStrength((INavigableVessel)ship);
        if (ship.getCaptian().isPresent()) {
            ICaptain captain = (ICaptain)ship.getCaptian().get();
            strength += captain.getFightSkillLevel() * 2;
        }
        return strength;
    }

    private void addPairing(List<IShip> attackingShips, List<IShip> defendingShips, List<GenericPair<List<IShip>, List<IShip>>> pairings, int i) {
        ArrayList<IShip> attackingShip = new ArrayList<IShip>();
        attackingShip.add(attackingShips.get(i));
        ArrayList<IShip> defending = new ArrayList<IShip>();
        defending.add(defendingShips.get(i));
        GenericPair pair = new GenericPair(attackingShip, defending);
        pairings.add((GenericPair<List<IShip>, List<IShip>>)pair);
    }

    public List<IShip> explodeShipList(IConvoy convoy) {
        return null;
    }

    public List<IShip> explodeShipList(IShipGroup group) {
        return null;
    }

    public List<IShip> explodeShipList(IShip ship) {
        ArrayList<IShip> ships = new ArrayList<IShip>();
        ships.add(ship);
        return ships;
    }

    public IShipGroup regroup(List<IShip> ships, IShipGroup oldGroup) {
        return null;
    }

    public IConvoy regroup(List<IShip> ships, IConvoy oldConvoy) {
        return null;
    }
}

