/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.sea.model;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.MapType;
import ch.sahits.game.openpatrician.engine.sea.model.NodeData;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javafx.geometry.Point2D;

@ClassCategory(value={EClassCategory.MODEL, EClassCategory.SINGLETON_BEAN})
public class GraphAStar<T>
implements Iterable<T> {
    @MapType(key=Point2D.class, value=Map.class)
    private Map<T, Map<NodeData<T>, Double>> graph;
    @MapType(key=Point2D.class, value=Map.class)
    private final Map<T, Map<T, Double>> heuristicMap;
    @MapType(key=Point2D.class, value=NodeData.class)
    private Map<T, NodeData<T>> nodeIdNodeData;

    public GraphAStar(Map<T, Map<T, Double>> heuristicMap) {
        Preconditions.checkNotNull(heuristicMap, (Object)"The huerisic map should not be null");
        this.graph = new HashMap<T, Map<NodeData<T>, Double>>();
        this.nodeIdNodeData = new HashMap<T, NodeData<T>>();
        this.heuristicMap = heuristicMap;
    }

    public void addNode(T nodeId, boolean isTargetNode) {
        Preconditions.checkNotNull(nodeId, (Object)"The node id cannot be null");
        if (!isTargetNode && !this.heuristicMap.containsKey(nodeId)) {
            throw new NoSuchElementException("This node (" + nodeId + ") is not a part of hueristic map");
        }
        this.graph.put(nodeId, new HashMap());
        this.nodeIdNodeData.put(nodeId, new NodeData<T>(nodeId, this.heuristicMap.get(nodeId)));
    }

    public void addNodeInternal(T nodeId) {
        Preconditions.checkNotNull(nodeId, (Object)"The node id cannot be null");
        this.graph.put(nodeId, new HashMap());
        this.nodeIdNodeData.put(nodeId, new NodeData<T>(nodeId, this.heuristicMap.get(nodeId)));
    }

    public void addEdge(T nodeIdFirst, T nodeIdSecond, double length) {
        if (nodeIdFirst == null || nodeIdSecond == null) {
            throw new NullPointerException("The first nor second node can be null.");
        }
        if (!this.heuristicMap.containsKey(nodeIdFirst) || !this.heuristicMap.containsKey(nodeIdSecond)) {
            throw new NoSuchElementException("Source and Destination both should be part of the part of hueristic map");
        }
        if (!this.graph.containsKey(nodeIdFirst) || !this.graph.containsKey(nodeIdSecond)) {
            throw new NoSuchElementException("Source and Destination both should be part of the part of graph");
        }
        this.graph.get(nodeIdFirst).put(this.nodeIdNodeData.get(nodeIdSecond), length);
        this.graph.get(nodeIdSecond).put(this.nodeIdNodeData.get(nodeIdFirst), length);
    }

    public void addEdgeInternal(T nodeIdFirst, T nodeIdSecond, double length) {
        if (nodeIdFirst == null || nodeIdSecond == null) {
            throw new NullPointerException("The first nor second node can be null.");
        }
        if (!this.graph.containsKey(nodeIdFirst) || !this.graph.containsKey(nodeIdSecond)) {
            throw new NoSuchElementException("Source and Destination both should be part of the part of graph");
        }
        this.graph.get(nodeIdFirst).put(this.nodeIdNodeData.get(nodeIdSecond), length);
        this.graph.get(nodeIdSecond).put(this.nodeIdNodeData.get(nodeIdFirst), length);
    }

    public Map<NodeData<T>, Double> edgesFrom(T nodeId) {
        Preconditions.checkNotNull(nodeId, (Object)"The node id cannot be null");
        if (!this.heuristicMap.containsKey(nodeId)) {
            throw new NoSuchElementException("This node is not a part of hueristic map");
        }
        if (!this.graph.containsKey(nodeId)) {
            throw new NoSuchElementException("The node should not be null.");
        }
        return Collections.unmodifiableMap(this.graph.get(nodeId));
    }

    public NodeData<T> getNodeData(T nodeId) {
        Preconditions.checkNotNull(nodeId, (Object)"The node id cannot be null");
        if (!this.nodeIdNodeData.containsKey(nodeId)) {
            throw new NoSuchElementException("The nodeId does not exist: " + nodeId);
        }
        return this.nodeIdNodeData.get(nodeId);
    }

    public boolean containsNode(T nodeId) {
        return this.nodeIdNodeData.containsKey(nodeId);
    }

    @Override
    public Iterator<T> iterator() {
        return this.graph.keySet().iterator();
    }

    public int size() {
        return this.graph.size();
    }
}

