/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.sea.model;

import ch.sahits.game.event.EGameStatusChange;
import ch.sahits.game.event.GameStateChange;
import ch.sahits.game.event.data.ClockTickIntervalChange;
import ch.sahits.game.event.data.PauseGame;
import ch.sahits.game.event.data.ResumeGame;
import ch.sahits.game.event.data.ShipArrivesAtDestinationEvent;
import ch.sahits.game.event.data.ShipEntersPortEvent;
import ch.sahits.game.event.data.ShipLeavingPort;
import ch.sahits.game.event.data.ShipNearingPortEvent;
import ch.sahits.game.event.data.ShipPositionUpdateEvent;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.clientserverinterface.model.PathInterpolatorMap;
import ch.sahits.game.openpatrician.clientserverinterface.model.VesselPositionUpdateData;
import ch.sahits.game.openpatrician.clientserverinterface.service.PathInterpolator;
import ch.sahits.game.openpatrician.clientserverinterface.service.PointService;
import ch.sahits.game.openpatrician.engine.sea.IPathConverter;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IMap;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.PausableSchedulableTask;
import ch.sahits.game.openpatrician.model.event.TargetedEvent;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import java.util.Iterator;
import java.util.Map;
import javafx.geometry.Point2D;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
@LazySingleton
public class ShipPositionUpdateTask
extends PausableSchedulableTask {
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    @Autowired
    private PathInterpolatorMap interpolators;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @Qualifier(value="timerEventBus")
    private AsyncEventBus timerEventBus;
    @Autowired
    private IMap map;
    @Autowired
    private IPathConverter pathConverter;
    @Autowired
    private PointService pointService;
    private long pausedTimeStamp = -1L;
    private final Object lock = new Object();

    @PostConstruct
    protected void register() {
        this.clientServerEventBus.register((Object)this);
        super.register();
        this.pause(new PauseGame());
    }

    @PreDestroy
    public void unregister() {
        this.clientServerEventBus.unregister((Object)this);
        super.unregister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(long now) {
        Object object = this.lock;
        synchronized (object) {
            Iterator iterator = this.interpolators.entrySet().iterator();
            while (iterator.hasNext()) {
                ICity city;
                Point2D source;
                Map.Entry entry = (Map.Entry)iterator.next();
                VesselPositionUpdateData value = (VesselPositionUpdateData)entry.getValue();
                PathInterpolator interpolator = value.getInterpolator();
                double traveldFraction = interpolator.getTraveldFraction();
                double travelPerTick = interpolator.getTravelFractionPerTick();
                double animationFraction = Math.min(1.0, traveldFraction + travelPerTick);
                INavigableVessel vessel = (INavigableVessel)entry.getKey();
                Point2D newLocation = interpolator.interpolate(animationFraction);
                Point2D oldLocation = vessel.getLocation();
                vessel.setLocation(newLocation);
                this.clientServerEventBus.post((Object)new ShipPositionUpdateEvent(vessel, oldLocation, newLocation));
                this.logger.trace("interpolate path move to {}, fraction={}", new Object[]{newLocation, animationFraction});
                if (value.isSourceCity() && oldLocation.distance(source = value.getSource()) < 10.0 && newLocation.distance(source) >= 10.0) {
                    city = this.map.findCity(source);
                    this.clientServerEventBus.post((Object)new ShipLeavingPort(vessel, city));
                }
                Point2D destination = value.getDestination();
                if (value.isDestinationCity() && newLocation.distance(destination) <= 10.0 && oldLocation.distance(destination) > 10.0) {
                    city = this.map.findCity(destination);
                    this.clientServerEventBus.post((Object)new ShipNearingPortEvent(vessel, city));
                }
                if (!this.pointService.equals(destination, newLocation)) continue;
                vessel.setLocation(destination);
                if (value.isDestinationCity()) {
                    city = this.map.findCity(destination);
                    this.clientServerEventBus.post((Object)new ShipEntersPortEvent(vessel, city));
                    if (vessel.getOwner() instanceof IHumanPlayer) {
                        DisplayMessage msg = new DisplayMessage("ch.sahits.game.openpatrician.engine.sea.model.ShipPositionUpdateTask.shipArrivedInCity", new Object[]{vessel.getName(), city.getName()});
                        this.clientServerEventBus.post((Object)new TargetedEvent((IHumanPlayer)vessel.getOwner(), (Object)msg));
                    }
                } else {
                    this.clientServerEventBus.post((Object)new ShipArrivesAtDestinationEvent(vessel, destination));
                    if (vessel.getOwner() instanceof IHumanPlayer) {
                        DisplayMessage msg = new DisplayMessage("ch.sahits.game.openpatrician.engine.sea.model.ShipPositionUpdateTask.shipArrivedAtDestination", new Object[]{vessel.getName()});
                        this.clientServerEventBus.post((Object)new TargetedEvent((IHumanPlayer)vessel.getOwner(), (Object)msg));
                    }
                }
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subscribe
    public void handleGameSpeedChange(ClockTickIntervalChange intervallChange) {
        Object object = this.lock;
        synchronized (object) {
            for (Map.Entry entry : this.interpolators.entrySet()) {
                VesselPositionUpdateData data = (VesselPositionUpdateData)entry.getValue();
                PathInterpolator interpolator = data.getInterpolator();
                double traveledFraction = interpolator.getTraveldFraction();
                double traveledTimeMS = (double)data.getDurationInMs() * traveledFraction;
                double fractionToTravel = 1.0 - traveledFraction;
                long remainingDuration = this.pathConverter.calculateDuration((INavigableVessel)entry.getKey(), interpolator, fractionToTravel);
                long newDuration = Math.round(traveledTimeMS + (double)remainingDuration);
                long nbTicks = remainingDuration / 100L;
                double fractionPerTick = fractionToTravel / (double)nbTicks;
                interpolator.setTravelFractionPerTick(fractionPerTick);
                data.setDurationInMs(newDuration);
                this.logger.trace("Update the game speed, fraction to travel={}, nbTicks={}, remainingDuration={}, update fraction per tick={}", new Object[]{fractionToTravel, nbTicks, remainingDuration, fractionPerTick});
            }
        }
    }

    public void pause(PauseGame evt) {
        this.logger.debug("Pause Task");
        this.pausedTimeStamp = System.currentTimeMillis();
        super.pause(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume(ResumeGame evt) {
        this.logger.debug("Resume Task, paused timestamp: {}", new Object[]{this.pausedTimeStamp});
        long pausedDurationMS = System.currentTimeMillis() - this.pausedTimeStamp;
        Object object = this.lock;
        synchronized (object) {
            for (VesselPositionUpdateData data : this.interpolators.values()) {
                long originalStartTimestampMS = data.getAnimationStartMS();
                long newStartTimestampNS = originalStartTimestampMS + pausedDurationMS;
                data.setAnimationStartMS(newStartTimestampNS);
                this.logger.trace("Change start time from {} -> {}", new Object[]{originalStartTimestampMS, newStartTimestampNS});
            }
        }
        super.resume(evt);
        this.pausedTimeStamp = -1L;
    }

    @Subscribe
    public void loadedGame(GameStateChange change) {
        if (change.getStatusChange() == EGameStatusChange.GAME_LOADED) {
            this.logger.trace("Reset the time, so it is calculated correctly on resume, so that the distance to travel is correct");
            if (this.interpolators.isEmpty()) {
                this.logger.trace("There are no ships traveling, so there is no need.");
            } else {
                for (Map.Entry entry : this.interpolators.entrySet()) {
                    VesselPositionUpdateData vesselData = (VesselPositionUpdateData)entry.getValue();
                    long totalDuration = vesselData.getDurationInMs();
                    double traveledFraction = vesselData.getInterpolator().getTraveldFraction();
                    long traveledTime = Math.round((double)totalDuration * traveledFraction);
                    long newStartTime = this.pausedTimeStamp - traveledTime;
                    vesselData.setAnimationStartMS(newStartTime);
                    this.logger.trace("Update the ship {} with new start animation time {}; totalDuration={}, traveledFraction={}, traveledTime={}ms", new Object[]{((INavigableVessel)entry.getKey()).getName(), newStartTime, totalDuration, traveledFraction, traveledTime});
                }
            }
        }
    }
}

