package ch.sahits.game.openpatrician.engine;

import ch.sahits.game.event.data.ClockTickDayChange;
import ch.sahits.game.event.data.ClockTickPostDayChange;
import ch.sahits.game.event.data.IClockTick;
import ch.sahits.game.event.data.PauseGame;
import ch.sahits.game.event.data.ResumeGame;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.event.IEventPropagator;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.util.Timer;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import javafx.application.Platform;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

/**
 * This clock ticking timer extends the pausable timer.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Sep 07, 2015
 */
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class ClockTickTimer extends Timer {
    private final Logger logger = LogManager.getLogger(getClass());
    @Autowired
    private Date clock;
    @Autowired
    @Qualifier("timerEventBus")
    private AsyncEventBus timerEventBus;
    @Autowired
    private IEventPropagator messagePropagator;

    private boolean dayChanged = false;

    /** Lock for guaranteeing thread safety */
    private static Object lock = new Object();

    public ClockTickTimer(long interval, long duration) {
        super(interval, duration);
    }
    @PostConstruct
    private void register() {
        timerEventBus.register(this);
    }
    @PreDestroy
    private void unregister() {
        timerEventBus.unregister(this);
    }

    @Override
    protected void onTick() {
        tick();
        timerEventBus.post(new IClockTick(){});
    }

    @Override
    protected void onFinish() {

    }
    /**
     * Update the time by one tick.
     */
    public void tick(){
        synchronized (lock) {
            int dayBefore = clock.getCurrentDate().getDayOfMonth();
            clock.updateTime(clock.getCurrentDate().plusMinutes(clock.getTickUpdate()));
            if (dayBefore!=clock.getCurrentDate().getDayOfMonth()){
                Platform.runLater(() ->
                        clock.dayDateBinding().invalidate());
                final ClockTickDayChange event = new ClockTickDayChange();
                timerEventBus.post(event);
                dayChanged = true;
                logger.info("Day change");
            }
            if (dayChanged) {
                dayChanged = false;
                final ClockTickPostDayChange event = new ClockTickPostDayChange();
                timerEventBus.post(event);
            }
        }
        timerEventBus.post(new ch.sahits.game.event.data.ClockTick());
    }
    @Subscribe
    public void handlePause(PauseGame event) {
        this.pause();
    }
    @Subscribe
    public void handleResume(ResumeGame event) {
        this.resume();
    }
}
