package ch.sahits.game.openpatrician.engine.player;

import ch.sahits.game.javafx.bindings.ConstantIntegerBinding;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.ICompany;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.ComputablePriceV2;
import ch.sahits.game.openpatrician.model.product.ITradeStep;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import javafx.beans.property.SimpleIntegerProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * Implements the trade step to by the some goods up to a maximum buy price.
 */
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@Prototype
public class BuyTradeStep implements ITradeStep {
//    @XStreamOmitField
//    private final Logger logger = LogManager.getLogger(getClass());
    @Setter
    private ICity city;
    @Setter
    @Getter
    private IWare ware;
    @Setter
    private int maxBuyPrice;
    @Setter
    private INavigableVessel vessel;
    @Autowired
    @XStreamOmitField
    private ComputablePriceV2 computablePrice;

    @Setter
    private boolean executeNext = true;

    @Override
    public boolean execute() {
        int availableAmount = city.getWare(ware).getAmount();
        IPlayer player = (IPlayer) vessel.getOwner();
        ICompany company = player.getCompany();
        int capacity = vessel.getCapacity();
        int maxAmount = capacity;
        if (!ware.isBarrelSizedWare()) {
            maxAmount /= 10;
        }
        int affordableAmount = computablePrice.calculateBuyAmount(ware, availableAmount, maxBuyPrice, maxAmount, company.getCash());
        if (affordableAmount > 0) {
            int buyPrice = computablePrice.buyPrice(ware, new SimpleIntegerProperty(availableAmount), new ConstantIntegerBinding(affordableAmount));
//            logger.trace("Before: cash={}, in city={}, on ship={}", company.getCash(), city.getWare(ware).getAmount(), vessel.getWare(ware).getAmount());
            company.updateCash(-buyPrice * affordableAmount);
            city.move(ware, -affordableAmount, player);
            vessel.load(ware, affordableAmount, buyPrice);
//            logger.trace("Bought {} of {} for a total of: {} ", affordableAmount, ware.name(), buyPrice*affordableAmount);
//            logger.trace("After: cash={}, in city={}, on ship={}", company.getCash(), city.getWare(ware).getAmount(), vessel.getWare(ware).getAmount());
        }
        // TODO ahotz 20.05.2016: handle case where there are ships owned by other players in the convoy
        return executeNext;
    }
}
