package ch.sahits.game.openpatrician.engine.player;

import ch.sahits.game.openpatrician.annotation.*;
import ch.sahits.game.openpatrician.model.player.IAIShipRepairStrategyType;
import ch.sahits.game.openpatrician.model.player.IAIStrategyProvider;
import ch.sahits.game.openpatrician.model.player.IAITakeLoanStrategyType;
import ch.sahits.game.openpatrician.model.player.IAITradeStrategyType;
import ch.sahits.game.openpatrician.util.StartNewGameBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.List;

/**
 * Provide the AI strategies defined in the core module.
 */
@Service
@Lazy
@DependentInitialisation(StartNewGameBean.class)
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class DefaultStrategyProvider implements IAIStrategyProvider {
    @ListType(IAIShipRepairStrategyType.class)
    private static List<IAIShipRepairStrategyType> repairStrategies = new ArrayList<>();
    @ListType(IAIShipRepairStrategyType.class)
    private static List<IAITradeStrategyType> tradeStrategies = new ArrayList<>();
    @ListType(IAITradeStrategyType.class)
    private static List<IAITakeLoanStrategyType> takeLoanStrategies = new ArrayList<>();
    @Autowired
    private ApplicationContext context;

    @PostConstruct
    private void init() {
        repairStrategies.add(EAIRepairStrategy.EIGHTY_PERCENT);
        repairStrategies.add(EAIRepairStrategy.ONLY_HOMEWOTN);
        repairStrategies.add(EAIRepairStrategy.ONLY_KONTOR_TYPE);
        repairStrategies.add(EAIRepairStrategy.ONLY_TRADINGOFFICE);
        repairStrategies.add(EAIRepairStrategy.ONLY_WEST);
        for (IAIShipRepairStrategyType strategy : repairStrategies) {
            ((EAIRepairStrategy)strategy).setApplicationContext(context);
        }
        tradeStrategies.add(EAITradeStrategyType.SUPPLY_HOMETOWN);
        tradeStrategies.add(EAITradeStrategyType.CHEAP_PRODUCTION);
        tradeStrategies.add(EAITradeStrategyType.TRADE_ROUTE);
        tradeStrategies.add(EAITradeStrategyType.PRODUCTION_CHAIN);
        for (IAITradeStrategyType strategy : tradeStrategies) {
            ((EAITradeStrategyType)strategy).setApplicationContext(context);
        }
        takeLoanStrategies.add(ETakeLoanStrategyType.LOW_MONEY_LONG_DURATION);
        for (IAITakeLoanStrategyType strategy : takeLoanStrategies) {
            ((ETakeLoanStrategyType)strategy).setApplicationContext(context);
        }
    }

    @Override
    public List<IAITradeStrategyType> getTradeStrategies() {
        return tradeStrategies;
    }

    @Override
    public List<IAIShipRepairStrategyType> getRepairStrategies() {
        return repairStrategies;
    }

    @Override
    public List<IAITakeLoanStrategyType> getTakeLoanStrategies() {
        return takeLoanStrategies;
    }
}
