package ch.sahits.game.openpatrician.engine.player;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.engine.AbstractEngine;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.PlayerList;
import com.google.common.eventbus.AsyncEventBus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * Engine handling automated tasks that are specific to a human player only.
 */
@LazySingleton
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class HumanPlayerEngine extends AbstractEngine {

    @Autowired
    private PlayerList players;
    @Autowired
    @Qualifier("serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @PostConstruct
    private void init() {
        clientServerEventBus.register(this);
    }
    @PreDestroy
    private void unregister() {
        clientServerEventBus.unregister(this);
    }

    @Override
    public List<AbstractEngine> getChildren() {
        return new ArrayList<>();
    }

    List<IPlayer> getHumanPlayers() {
        return players.stream().filter(p -> p instanceof IHumanPlayer).collect(Collectors.toList());
    }
}
