package ch.sahits.game.openpatrician.engine.player;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.clientserverinterface.service.LoanerService;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.ILoaner;
import ch.sahits.game.openpatrician.model.city.LoanerList;
import ch.sahits.game.openpatrician.model.city.impl.ILoanProposal;
import ch.sahits.game.openpatrician.model.player.IAITakeLoanStrategy;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * Strategy for loan taking. The strategy takes effect when the money is low and taking the loan with the longest
 * duration.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Jun 12, 2016
 */
@LazySingleton
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class TakeLoanLowMoneyLongestDurationStrategy implements IAITakeLoanStrategy {
    @Autowired
    private LoanerList loaners;
    @Autowired
    private LoanerService loanerService;
    @Override
    public boolean shouldTakeLoan(IAIPlayer player) {
        long cash = player.getCompany().getCash();
        return cash < 5000;
    }

    @Override
    public void takeLoan(IAIPlayer player, ICity city) {
        ILoaner loaner = loanerService.findLoaner(city);
        List<ILoanProposal> loans = loaner.getLoanProposals();
        ILoanProposal longest = null;
        for (ILoanProposal loan : loans) {
            if (longest == null) {
                longest = loan;
            } else {
                if (loan.getDurationInWeeks() > longest.getDurationInWeeks()) {
                    longest = loan;
                }
            }
        }
        if (longest != null) {
             loanerService.takeOutLoan(loaner, longest, player, city);
        }

    }
}
