/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine;

import ch.sahits.game.event.data.GraphInitialisationComplete;
import ch.sahits.game.event.data.ShipEntersPortEvent;
import ch.sahits.game.event.data.ai.BlockadeShipRequestEvent;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.clientserverinterface.service.MapService;
import ch.sahits.game.openpatrician.engine.AbstractEngine;
import ch.sahits.game.openpatrician.engine.player.BlockadeStrategy;
import ch.sahits.game.openpatrician.engine.sea.SeafaringService;
import ch.sahits.game.openpatrician.model.AIPlayerList;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.IShipEntersPortEvent;
import ch.sahits.game.openpatrician.model.people.IShipOwner;
import ch.sahits.game.openpatrician.model.player.IAITradeStrategy;
import ch.sahits.game.openpatrician.model.player.IProductionConsumptionKnowledge;
import ch.sahits.game.openpatrician.model.product.IBlockadeMission;
import ch.sahits.game.openpatrician.model.product.ISpecialMission;
import ch.sahits.game.openpatrician.model.product.ITradeMissionData;
import ch.sahits.game.openpatrician.model.sea.BlockadeState;
import ch.sahits.game.openpatrician.model.sea.IBlockade;
import ch.sahits.game.openpatrician.model.sea.TravellingVessels;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class AIPlayerEngine
extends AbstractEngine {
    private final Logger logger = LogManager.getLogger(this.getClass());
    @Autowired
    private AIPlayerList players;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    private BlockadeState blockadeState;
    @Autowired
    private BlockadeStrategy blockadeStrategy;
    @Autowired
    private SeafaringService seafaringService;
    @Autowired
    private Date date;
    @Autowired
    private MapService mapService;
    @Autowired
    private TravellingVessels vessels;

    @Override
    public List<AbstractEngine> getChildren() {
        return Collections.emptyList();
    }

    @PostConstruct
    private void init() {
        for (IAIPlayer player : this.players) {
            ICity hometown = player.getHometown();
            IProductionConsumptionKnowledge knowlege = player.getProductionAndConsumptionKnowledge();
            knowlege.updateKnowledge(hometown);
            List shipList = player.getFleet();
            for (IShip ship : shipList) {
                try {
                    this.initializeStrategyForVessel(player, (INavigableVessel)ship);
                }
                catch (RuntimeException e) {
                    this.logger.error("Failed to initialize strategy for ship  " + ship.getName() + " of " + player.getName() + " " + player.getLastName(), (Throwable)e);
                }
            }
        }
        this.clientServerEventBus.register((Object)this);
    }

    private void initializeStrategyForVessel(IAIPlayer player, INavigableVessel ship) {
        IAITradeStrategy tradeStrategy = player.getTradeStrategyType().getStrategy();
        tradeStrategy.initialzeTradeCycle(player, ship);
    }

    @Subscribe
    public void handleBlockadeStart(BlockadeShipRequestEvent event) {
        Optional<IShip> optShip;
        IAIPlayer player = event.getPlayer();
        int requiredShips = event.getNumberOfShips();
        for (int i = 0; i < requiredShips && (optShip = this.blockadeStrategy.selectShip(player)).isPresent(); ++i) {
            IShip vessel = optShip.get();
            player.setTradeMission((INavigableVessel)vessel, (ITradeMissionData)new IBlockadeMission(){});
            this.seafaringService.travelTo((INavigableVessel)vessel, event.getAssemblyCity().getCoordinates());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Subscribe
    public void handleShipArrivesInCity(ShipEntersPortEvent event) {
        INavigableVessel vessel = event.getShip();
        IShipOwner owner = vessel.getOwner();
        this.vessels.remove(vessel);
        if (!(owner instanceof IAIPlayer)) return;
        IAIPlayer player = (IAIPlayer)owner;
        IProductionConsumptionKnowledge knowlege = player.getProductionAndConsumptionKnowledge();
        knowlege.updateKnowledge(event.getCity());
        ITradeMissionData missionData = player.getTradeMission(vessel);
        if (missionData instanceof ISpecialMission) {
            if (!(missionData instanceof IBlockadeMission)) throw new IllegalStateException("The special mission " + missionData + " is not implemented");
            this.handleBlockadeMission(vessel, player, event.getCity());
            return;
        }
        player.updateTradeWaitingStatus(vessel, false);
        IAITradeStrategy strategy = player.getTradeStrategyType().getStrategy();
        try {
            strategy.handleShipArrivesInPort((IShipEntersPortEvent)event);
            return;
        }
        catch (RuntimeException e) {
            this.logger.error("Failed to handle ship arrival of " + vessel.getName() + " of " + player.getName() + " " + player.getLastName(), (Throwable)e);
        }
    }

    @Subscribe
    public void handleTradeStrategyStart(GraphInitialisationComplete event) {
        for (IAIPlayer player : this.players) {
            List shipList = player.getSelectableVessels();
            IAITradeStrategy tradeStrategy = player.getTradeStrategyType().getStrategy();
            for (INavigableVessel ship : shipList) {
                if (player.waitingForTradeStepToFinish(ship)) continue;
                tradeStrategy.executeTradeSteps(player, ship);
            }
        }
    }

    private void handleBlockadeMission(INavigableVessel vessel, IAIPlayer player, ICity city) {
        DateTime now = this.date.getCurrentDate();
        ICity aldermanCity = this.mapService.getAldermanCity();
        if (city.equals(aldermanCity)) {
            if (this.blockadeState.entrySet().isEmpty()) {
                this.initializeStrategyForVessel(player, vessel);
            } else {
                for (Map.Entry entry : this.blockadeState.entrySet()) {
                    IBlockade blockade = (IBlockade)entry.getValue();
                    if (!blockade.getAssemblyDate().isBefore((ReadableInstant)now)) continue;
                    this.initializeStrategyForVessel(player, vessel);
                }
            }
        } else {
            this.initializeStrategyForVessel(player, vessel);
        }
    }
}

