/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.event.task;

import ch.sahits.game.event.data.RepairFinishedEvent;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.people.ISeaPirate;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.ship.IShipGroup;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class RepairPirateShipTask
extends TimedTask {
    @Autowired
    @XStreamOmitField
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    private final INavigableVessel vessel;
    private final ISeaPirate pirate;

    public RepairPirateShipTask(DateTime executionTime, INavigableVessel vessel, ISeaPirate pirate) {
        Preconditions.checkArgument((vessel instanceof IShip || vessel instanceof IShipGroup ? 1 : 0) != 0);
        this.setExecutionTime(executionTime);
        this.vessel = vessel;
        this.pirate = pirate;
    }

    public void run() {
        if (this.vessel instanceof IShip) {
            IShip ship = (IShip)this.vessel;
            ship.repair();
            ship.setAvailable(true);
        } else {
            for (IShip ship : ((IShipGroup)this.vessel).getShips()) {
                ship.repair();
                ship.setAvailable(true);
            }
        }
        this.clientServerEventBus.post((Object)new RepairFinishedEvent(this.vessel));
    }
}

