/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.land.city;

import ch.sahits.game.event.data.PeriodicalDailyUpdate;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.clientserverinterface.service.WareAmountCalculator;
import ch.sahits.game.openpatrician.engine.AbstractEngine;
import ch.sahits.game.openpatrician.engine.time.EUpdateIntervalRegistration;
import ch.sahits.game.openpatrician.engine.time.IIndividualPeriodicalUpdater;
import ch.sahits.game.openpatrician.model.IBalanceSheet;
import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.ETradeType;
import ch.sahits.game.openpatrician.model.building.IAutomatedTrading;
import ch.sahits.game.openpatrician.model.building.ISteward;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.building.TradingOfficeList;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.BuildingFinished;
import ch.sahits.game.openpatrician.model.product.ComputablePriceV2;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.ITradable;
import ch.sahits.game.openpatrician.model.product.IWare;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class AutomaticTradingEngine
extends AbstractEngine {
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    private IIndividualPeriodicalUpdater updater;
    @Autowired
    private WareAmountCalculator calculator;
    @Autowired
    private TradingOfficeList offices;
    @Autowired
    private ComputablePriceV2 computablePrice;

    @PreDestroy
    private void unregister() {
        this.clientServerEventBus.unregister((Object)this);
    }

    @PostConstruct
    private void initialize() {
        this.clientServerEventBus.register((Object)this);
    }

    @Override
    public List<AbstractEngine> getChildren() {
        return new ArrayList<AbstractEngine>();
    }

    @Subscribe
    public void handleTradingOfficeBuilt(BuildingFinished event) {
        if (event.getBuilding() instanceof ITradingOffice) {
            final ITradingOffice tradingOffice = (ITradingOffice)event.getBuilding();
            this.offices.add(tradingOffice);
            Preconditions.checkState((tradingOffice.getSteward() == null ? 1 : 0) != 0, (Object)"Stewart must be null on building");
            final AutomaticTradingEngine engine = this;
            tradingOffice.stewardProperty().addListener((ChangeListener)new ChangeListener<ISteward>(){

                public void changed(ObservableValue<? extends ISteward> observableValue, ISteward oldSteward, ISteward newSteward) {
                    if (newSteward == null) {
                        AutomaticTradingEngine.this.updater.unregister(tradingOffice);
                    } else {
                        AutomaticTradingEngine.this.updater.register(engine, tradingOffice, EUpdateIntervalRegistration.DAILY);
                    }
                }
            });
        }
    }

    @Subscribe
    public void handleDailyUpdates(PeriodicalDailyUpdate event) {
        if (event.isAddresse((Object)this) && event.getTarget() instanceof ITradingOffice) {
            ITradingOffice target = (ITradingOffice)event.getTarget();
            for (ITradingOffice office : this.offices) {
                if (!target.equals(office)) continue;
                this.sellAndBuy(office);
                break;
            }
        }
    }

    @VisibleForTesting
    void sellAndBuy(ITradingOffice office) {
        Preconditions.checkNotNull((Object)office.getSteward(), (Object)"Steward may not be null");
        Preconditions.checkNotNull((Object)office.getOfficeTrading(), (Object)"OfficeTrading may not be null");
        ISteward steward = office.getSteward();
        IAutomatedTrading automatedTrading = office.getOfficeTrading();
        IBalanceSheet balanceSheet = office.getCurrentWeek();
        for (EWare ware : EWare.values()) {
            ICity city;
            if (automatedTrading.tradingTypeProperty((IWare)ware).get() == ETradeType.CITY_OFFICE) {
                double discountFactor = steward.getDiscountFactor();
                int avgPrice = automatedTrading.getPrice((IWare)ware);
                city = office.getCity();
                final int amountToBuy = this.calculator.calculateBuyAmount((IWare)ware, city, avgPrice);
                int price = this.computablePrice.buyPrice((ITradable)ware, (IntegerProperty)new SimpleIntegerProperty(city.getWare((IWare)ware).getAmount()), new IntegerBinding(){

                    protected int computeValue() {
                        return amountToBuy;
                    }
                });
                IPlayer owner = office.getOwner();
                int amountBought = city.move((IWare)ware, -amountToBuy, (ICitizen)owner);
                office.move((IWare)ware, -amountBought, (int)((double)price * discountFactor));
                long totalPrice = (long)((double)(-amountBought * price) * discountFactor);
                owner.getCompany().updateCash(-totalPrice);
                balanceSheet.updateAutomatedTradingCosts(-totalPrice);
            }
            if (automatedTrading.tradingTypeProperty((IWare)ware).get() != ETradeType.OFFICE_CITY) continue;
            int withouldingAmount = automatedTrading.getAmount((IWare)ware);
            int amountInOffice = office.getWare((IWare)ware).getAmount();
            if (amountInOffice < withouldingAmount) continue;
            int wareAvgPrice = office.getWare((IWare)ware).getAVGPrice();
            city = office.getCity();
            int avgPrice = automatedTrading.getPrice((IWare)ware);
            int amountToSellProposed = this.calculator.calculateSellAmount((IWare)ware, city, avgPrice);
            final int amountToSell = Math.min(amountToSellProposed, amountInOffice - withouldingAmount);
            int price = this.computablePrice.sellPrice((ITradable)ware, (IntegerProperty)new SimpleIntegerProperty(city.getWare((IWare)ware).getAmount()), new IntegerBinding(){

                protected int computeValue() {
                    return amountToSell;
                }
            });
            IPlayer owner = office.getOwner();
            int amountSold = city.move((IWare)ware, -amountToSell, (ICitizen)owner);
            office.move((IWare)ware, amountSold);
            long totalPrice = amountSold * price;
            owner.getCompany().updateCash(totalPrice);
            balanceSheet.updateAutomatedTradingCosts(totalPrice);
            int profit = (int)(totalPrice - (long)(amountSold * wareAvgPrice));
            steward.updateProfit(profit);
        }
    }
}

