/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.land.city;

import ch.sahits.game.event.data.PeriodicalDailyUpdate;
import ch.sahits.game.event.data.PeriodicalTimeWeekUpdate;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.clientserverinterface.model.factory.StateFactory;
import ch.sahits.game.openpatrician.dialog.ButtonTemplate;
import ch.sahits.game.openpatrician.dialog.DialogTemplate;
import ch.sahits.game.openpatrician.engine.AbstractEngine;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.ICompany;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.ICreditor;
import ch.sahits.game.openpatrician.model.city.ILoaner;
import ch.sahits.game.openpatrician.model.city.LoanerList;
import ch.sahits.game.openpatrician.model.city.impl.IDebt;
import ch.sahits.game.openpatrician.model.event.TargetedEvent;
import ch.sahits.game.openpatrician.model.personal.ESocialRank;
import ch.sahits.game.openpatrician.model.personal.IReputation;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class LoanerEngine
extends AbstractEngine {
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    private StateFactory factory;
    @Autowired
    private Date date;
    @Autowired
    private Random rnd;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private LoanerList loaners;
    @Autowired
    private StateFactory stateFactory;

    @PostConstruct
    private void init() {
        this.clientServerEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregister() {
        this.clientServerEventBus.unregister((Object)this);
    }

    @Subscribe
    public void handleWeeklyUpdate(PeriodicalTimeWeekUpdate event) {
        for (ILoaner loaner : this.loaners) {
            this.stateFactory.updateLoanerRequestsAndLoans(loaner);
        }
    }

    @Subscribe
    public void handleDailyUpdate(PeriodicalDailyUpdate event) {
        DateTime now = this.date.getCurrentDate();
        for (ILoaner loaner : this.loaners) {
            List debts = loaner.getDebts();
            Iterator iterator = debts.iterator();
            while (iterator.hasNext()) {
                IDebt debt = (IDebt)iterator.next();
                if (!debt.getDueDate().isBefore((ReadableInstant)now)) continue;
                ICitizen debitor = debt.getDebitor();
                int cash = (int)((double)debt.getAmount() * debt.getInterest());
                if (debitor instanceof IPlayer) {
                    IPlayer player = (IPlayer)debitor;
                    ICompany company = player.getCompany();
                    if (company.getCash() > (long)cash) {
                        company.updateCash((long)(-cash));
                        if (debt.getCreditor() instanceof IPlayer) {
                            ((IPlayer)debt.getCreditor()).getCompany().updateCash((long)cash);
                        }
                    } else {
                        this.postMessageDebtNotFulfillable(debt);
                    }
                } else if (debitor.getRank().equals((Object)ESocialRank.BARGAINER) || debitor.getRank().equals((Object)ESocialRank.CHANDLER) || debitor.getRank().equals((Object)ESocialRank.MERCHANT) || debitor.getRank().equals((Object)ESocialRank.TRADESMAN)) {
                    int payBack = this.rnd.nextInt(4);
                    if (payBack == 0) {
                        this.postMessageDebtNotFulfillable(debt);
                    } else if (debt.getCreditor() instanceof IPlayer) {
                        ((IPlayer)debt.getCreditor()).getCompany().updateCash((long)cash);
                    }
                } else if (debt.getCreditor() instanceof IPlayer) {
                    ((IPlayer)debt.getCreditor()).getCompany().updateCash((long)cash);
                }
                iterator.remove();
            }
        }
    }

    @VisibleForTesting
    void postMessageDebtNotFulfillable(IDebt debt) {
        String titleTemplate = "ch.sahits.game.openpatrician.engine.land.city.LoanerEngine.paybackTitle";
        String messageTemplate = "ch.sahits.game.openpatrician.engine.land.city.LoanerEngine.paybackMessage";
        String remitBtnLbl = "ch.sahits.game.openpatrician.engine.land.city.LoanerEngine.remitBtn";
        String pawnBtnLbl = "ch.sahits.game.openpatrician.engine.land.city.LoanerEngine.pawnBtn";
        int sum = (int)((double)debt.getAmount() * debt.getInterest());
        Object[] messageArgs = new Object[]{debt.getDebitor().getName(), debt.getDebitor().getLastName(), sum};
        Runnable remit = this.createRemitRunnable(debt);
        Runnable pawn = this.createPawnRunnable(debt);
        ArrayList<ButtonTemplate> buttons = new ArrayList<ButtonTemplate>();
        ButtonTemplate remitBtn = ButtonTemplate.builder().action(remit).labelKey(remitBtnLbl).largeButton(true).build();
        ButtonTemplate pawnBtn = ButtonTemplate.builder().action(pawn).labelKey(pawnBtnLbl).largeButton(true).build();
        buttons.add(remitBtn);
        buttons.add(pawnBtn);
        DialogTemplate dialogTemplate = DialogTemplate.builder().titleKey(titleTemplate).messageKey(messageTemplate).messageArgs(messageArgs).buttons(buttons).closable(false).build();
        DisplayMessage displayMessage = new DisplayMessage(titleTemplate, new Object[0]);
        displayMessage.setDialogTemplate(dialogTemplate);
        if (debt.getDebitor() instanceof IHumanPlayer) {
            TargetedEvent message = new TargetedEvent((IHumanPlayer)debt.getDebitor(), (Object)displayMessage);
            this.clientServerEventBus.post((Object)message);
        }
    }

    @VisibleForTesting
    Runnable createRemitRunnable(final IDebt debt) {
        return new Runnable(){

            @Override
            public void run() {
                ICreditor creditor = debt.getCreditor();
                if (creditor instanceof IPlayer) {
                    ICity city = debt.getDebitor().getHometown();
                    IReputation reputation = city.getReputation((IPlayer)creditor);
                    reputation.update(500);
                }
            }
        };
    }

    @VisibleForTesting
    Runnable createPawnRunnable(final IDebt debt) {
        return new Runnable(){

            @Override
            public void run() {
                if (debt.getDebitor() instanceof IHumanPlayer) {
                    int sum = (int)((double)debt.getAmount() * debt.getInterest());
                    IPlayer player = (IPlayer)debt.getDebitor();
                    IShip shipMatch = null;
                    int maxDelta = Integer.MAX_VALUE;
                    for (IShip ship : player.getFleet()) {
                        int shipValue = ship.getValue();
                        if (Math.abs(shipValue - sum) >= maxDelta) continue;
                        maxDelta = Math.abs(shipValue - sum);
                        shipMatch = ship;
                    }
                } else if (debt.getCreditor() instanceof IHumanPlayer) {
                    int value = LoanerEngine.this.rnd.nextInt(debt.getAmount() / 2) + debt.getAmount();
                    value = (int)Math.min((double)value, (double)debt.getAmount() * debt.getInterest());
                    ((IPlayer)debt.getCreditor()).getCompany().updateCash((long)value);
                    ICitizen debitor = debt.getDebitor();
                    DisplayMessage msg = new DisplayMessage("ch.sahits.game.openpatrician.engine.land.city.LoanerEngine.pawnMsg1", new Object[]{debitor.getName(), debitor.getLastName(), value});
                    TargetedEvent message = new TargetedEvent((IHumanPlayer)debt.getCreditor(), (Object)msg);
                    LoanerEngine.this.clientServerEventBus.post((Object)message);
                }
            }
        };
    }

    void addNewLoaner(ICity city) {
        this.factory.createLoaner(city);
    }

    @Override
    public List<AbstractEngine> getChildren() {
        return new ArrayList<AbstractEngine>();
    }

    public List<IDebt> findDebts(ILoaner loaner, IPlayer player) {
        ArrayList<IDebt> filteredList = new ArrayList<IDebt>();
        for (IDebt debt : loaner.getDebts()) {
            if (!player.equals(debt.getDebitor())) continue;
            filteredList.add(debt);
        }
        return filteredList;
    }

    public List<IDebt> findLoans(ILoaner loaner, IPlayer creditor) {
        ArrayList<IDebt> filteredList = new ArrayList<IDebt>();
        for (IDebt debt : loaner.getDebts()) {
            if (!creditor.equals(debt.getCreditor())) continue;
            filteredList.add(debt);
        }
        return filteredList;
    }
}

