/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.land.city;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.clientserverinterface.service.CityProductionAndConsumptionService;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.EPopulationClass;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.PopulationConsume;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Lazy
@Component
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class ReputationCalculator {
    @Autowired
    private PopulationConsume consumer;
    @Autowired
    private CityProductionAndConsumptionService cityProductionAndConsumptionService;

    public int calculateWareRepputation(ICity city, IPlayer player) {
        EWare[] wares;
        double reputation = 0.0;
        for (EWare ware : wares = EWare.values()) {
            int contribution;
            int cityProduction;
            double need = this.consumer.getNeed((IWare)ware, EPopulationClass.POOR, city.getPopulation(EPopulationClass.POOR));
            need += this.consumer.getNeed((IWare)ware, EPopulationClass.MEDIUM, city.getPopulation(EPopulationClass.MEDIUM));
            if (!((need += this.consumer.getNeed((IWare)ware, EPopulationClass.RICH, city.getPopulation(EPopulationClass.RICH))) > (double)(cityProduction = this.cityProductionAndConsumptionService.getProductionOutputCurrentWeek((IWare)ware, city))) || (contribution = city.getContribution(player, (IWare)ware)) <= 0) continue;
            if ((double)contribution > need) {
                reputation += 100.0;
                continue;
            }
            reputation += (double)contribution / need;
        }
        return (int)Math.rint(reputation / (double)wares.length);
    }
}

