/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player;

import ch.sahits.game.javafx.bindings.ConstantIntegerBinding;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.ICompany;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.ComputablePriceV2;
import ch.sahits.game.openpatrician.model.product.ITradable;
import ch.sahits.game.openpatrician.model.product.ITradeStep;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import org.springframework.beans.factory.annotation.Autowired;

@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@Prototype
public class BuyTradeStep
implements ITradeStep {
    private ICity city;
    private IWare ware;
    private int maxBuyPrice;
    private INavigableVessel vessel;
    @Autowired
    @XStreamOmitField
    private ComputablePriceV2 computablePrice;
    private boolean executeNext = true;

    public boolean execute() {
        int affordableAmount;
        int capacity;
        int availableAmount = this.city.getWare(this.ware).getAmount();
        IPlayer player = (IPlayer)this.vessel.getOwner();
        ICompany company = player.getCompany();
        int maxAmount = capacity = this.vessel.getCapacity();
        if (!this.ware.isBarrelSizedWare()) {
            maxAmount /= 10;
        }
        if ((affordableAmount = this.computablePrice.calculateBuyAmount((ITradable)this.ware, availableAmount, this.maxBuyPrice, maxAmount, company.getCash())) > 0) {
            int buyPrice = this.computablePrice.buyPrice((ITradable)this.ware, (IntegerProperty)new SimpleIntegerProperty(availableAmount), (IntegerBinding)new ConstantIntegerBinding(affordableAmount));
            company.updateCash((long)(-buyPrice * affordableAmount));
            this.city.move(this.ware, -affordableAmount, (ICitizen)player);
            this.vessel.load(this.ware, affordableAmount, buyPrice);
        }
        return this.executeNext;
    }

    public void setCity(ICity city) {
        this.city = city;
    }

    public void setWare(IWare ware) {
        this.ware = ware;
    }

    public IWare getWare() {
        return this.ware;
    }

    public void setMaxBuyPrice(int maxBuyPrice) {
        this.maxBuyPrice = maxBuyPrice;
    }

    public void setVessel(INavigableVessel vessel) {
        this.vessel = vessel;
    }

    public void setExecuteNext(boolean executeNext) {
        this.executeNext = executeNext;
    }
}

