/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.clientserverinterface.service.ShipService;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.ICompany;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.player.IAIShipRepairStrategy;
import ch.sahits.game.openpatrician.model.product.ITradeStep;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@Prototype
public class CheckForRepairTradeStep
implements ITradeStep {
    @XStreamOmitField
    private final Logger logger = LogManager.getLogger(this.getClass());
    private ICity city;
    private INavigableVessel vessel;
    @Autowired
    @XStreamOmitField
    private ShipService shipService;

    public boolean execute() {
        IAIPlayer owner = (IAIPlayer)this.vessel.getOwner();
        IAIShipRepairStrategy repairStrategy = owner.getShipRepairStrategyType().getStrategy();
        if (repairStrategy.shouldRepair(this.vessel, this.city)) {
            repairStrategy.repair(this.vessel, this.city);
            ICompany company = owner.getCompany();
            int costs = this.vessel instanceof IShip ? this.shipService.calculateRepairCosts(this.city, (IShip)this.vessel) : this.shipService.calculateRepairCostsVessel(this.city, this.vessel);
            company.updateCash((long)(-costs));
            this.logger.debug("Executed repair check, do NOT proceed for vessel {} in {}", new Object[]{this.vessel.getName(), this.city.getName()});
            return false;
        }
        this.logger.debug("Executed repair check, do proceed for vessel {} in {}", new Object[]{this.vessel.getName(), this.city.getName()});
        return true;
    }

    public String toString() {
        return "CheckForRepairTradeStep in " + this.city.getName() + " " + ((IAIPlayer)this.vessel.getOwner()).getShipRepairStrategyType();
    }

    public void setCity(ICity city) {
        this.city = city;
    }

    public void setVessel(INavigableVessel vessel) {
        this.vessel = vessel;
    }
}

