/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ListType;
import ch.sahits.game.openpatrician.engine.player.EAIRepairStrategy;
import ch.sahits.game.openpatrician.engine.player.EAITradeStrategyType;
import ch.sahits.game.openpatrician.engine.player.ETakeLoanStrategyType;
import ch.sahits.game.openpatrician.model.player.IAIShipRepairStrategyType;
import ch.sahits.game.openpatrician.model.player.IAIStrategyProvider;
import ch.sahits.game.openpatrician.model.player.IAITakeLoanStrategyType;
import ch.sahits.game.openpatrician.model.player.IAITradeStrategyType;
import ch.sahits.game.openpatrician.util.StartNewGameBean;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy
@DependentInitialisation(value=StartNewGameBean.class)
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class DefaultStrategyProvider
implements IAIStrategyProvider {
    @ListType(value=IAIShipRepairStrategyType.class)
    private static List<IAIShipRepairStrategyType> repairStrategies = new ArrayList<IAIShipRepairStrategyType>();
    @ListType(value=IAIShipRepairStrategyType.class)
    private static List<IAITradeStrategyType> tradeStrategies = new ArrayList<IAITradeStrategyType>();
    @ListType(value=IAITradeStrategyType.class)
    private static List<IAITakeLoanStrategyType> takeLoanStrategies = new ArrayList<IAITakeLoanStrategyType>();
    @Autowired
    private ApplicationContext context;

    @PostConstruct
    private void init() {
        repairStrategies.add(EAIRepairStrategy.EIGHTY_PERCENT);
        repairStrategies.add(EAIRepairStrategy.ONLY_HOMEWOTN);
        repairStrategies.add(EAIRepairStrategy.ONLY_KONTOR_TYPE);
        repairStrategies.add(EAIRepairStrategy.ONLY_TRADINGOFFICE);
        repairStrategies.add(EAIRepairStrategy.ONLY_WEST);
        for (IAIShipRepairStrategyType iAIShipRepairStrategyType : repairStrategies) {
            ((EAIRepairStrategy)iAIShipRepairStrategyType).setApplicationContext(this.context);
        }
        tradeStrategies.add(EAITradeStrategyType.SUPPLY_HOMETOWN);
        tradeStrategies.add(EAITradeStrategyType.CHEAP_PRODUCTION);
        tradeStrategies.add(EAITradeStrategyType.TRADE_ROUTE);
        tradeStrategies.add(EAITradeStrategyType.PRODUCTION_CHAIN);
        for (IAITradeStrategyType iAITradeStrategyType : tradeStrategies) {
            ((EAITradeStrategyType)iAITradeStrategyType).setApplicationContext(this.context);
        }
        takeLoanStrategies.add(ETakeLoanStrategyType.LOW_MONEY_LONG_DURATION);
        for (IAITakeLoanStrategyType iAITakeLoanStrategyType : takeLoanStrategies) {
            ((ETakeLoanStrategyType)iAITakeLoanStrategyType).setApplicationContext(this.context);
        }
    }

    public List<IAITradeStrategyType> getTradeStrategies() {
        return tradeStrategies;
    }

    public List<IAIShipRepairStrategyType> getRepairStrategies() {
        return repairStrategies;
    }

    public List<IAITakeLoanStrategyType> getTakeLoanStrategies() {
        return takeLoanStrategies;
    }
}

