/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player;

import ch.sahits.game.javafx.bindings.ConstantIntegerBinding;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.ICompany;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.ComputablePriceV2;
import ch.sahits.game.openpatrician.model.product.ITradable;
import ch.sahits.game.openpatrician.model.product.ITradeStep;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@Prototype
public class SellDumpTradeStep
implements ITradeStep {
    @XStreamOmitField
    private final Logger logger = LogManager.getLogger(this.getClass());
    private ICity city;
    private IWare ware;
    private INavigableVessel vessel;
    @Autowired
    @XStreamOmitField
    private ComputablePriceV2 computablePrice;

    public boolean execute() {
        int availableAmount = this.city.getWare(this.ware).getAmount();
        int sellAmount = this.vessel.getWare(this.ware).getAmount();
        if (sellAmount > 0) {
            int sellPrice = this.computablePrice.sellPrice((ITradable)this.getWare(), (IntegerProperty)new SimpleIntegerProperty(availableAmount), (IntegerBinding)new ConstantIntegerBinding(sellAmount));
            IAIPlayer player = (IAIPlayer)this.vessel.getOwner();
            ICompany company = player.getCompany();
            this.logger.trace("Before: cash={}, in city={}, on ship={}", new Object[]{company.getCash(), this.city.getWare(this.ware).getAmount(), this.vessel.getWare(this.ware).getAmount()});
            company.updateCash((long)(sellPrice * sellAmount));
            this.city.move(this.getWare(), sellAmount, (ICitizen)player);
            this.vessel.load(this.getWare(), sellAmount, sellPrice);
            this.logger.trace("Sold {} of {} for a total of: {} ", new Object[]{sellAmount, this.ware.name(), sellPrice * sellAmount});
            this.logger.trace("After: cash={}, in city={}, on ship={}", new Object[]{company.getCash(), this.city.getWare(this.ware).getAmount(), this.vessel.getWare(this.ware).getAmount()});
        }
        return true;
    }

    public void setCity(ICity city) {
        this.city = city;
    }

    public void setWare(IWare ware) {
        this.ware = ware;
    }

    public IWare getWare() {
        return this.ware;
    }

    public void setVessel(INavigableVessel vessel) {
        this.vessel = vessel;
    }
}

