/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.sea;

import ch.sahits.game.event.data.ClockTick;
import ch.sahits.game.event.data.ShipPositionUpdateEvent;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.dialog.DialogTemplate;
import ch.sahits.game.openpatrician.engine.sea.LocationTracker;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.cityhall.IAcceptedAldermanTask;
import ch.sahits.game.openpatrician.model.city.cityhall.ICapturePirateNest;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.AldermanOffice;
import ch.sahits.game.openpatrician.model.event.TargetedEvent;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.model.map.MapSegmentedImage;
import ch.sahits.game.openpatrician.model.map.PirateMapSegmentImage;
import ch.sahits.game.openpatrician.model.map.TreasureMapSegmentImage;
import ch.sahits.game.openpatrician.model.personal.IReputation;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.server.MapLocationDetectionModel;
import ch.sahits.game.openpatrician.server.MapSegmentDataCheck;
import ch.sahits.game.openpatrician.util.StartNewGameBean;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javafx.geometry.Point2D;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
@Component
@Lazy
@DependentInitialisation(value=StartNewGameBean.class)
public class MapLocationDetector {
    @Value(value="${seamap.visibility.distance}")
    private int locationDistance = 5;
    @Autowired
    private MapLocationDetectionModel dataModel;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @Qualifier(value="syncServerClientEventBus")
    private EventBus syncServerClientEventBus;
    @Autowired
    @Qualifier(value="timerEventBus")
    private AsyncEventBus timerEventBus;
    @Autowired
    private Date date;
    @Autowired
    private AldermanOffice aldermanOffice;
    @Autowired
    private IMap map;
    @Autowired
    private Random rnd;
    @Autowired
    private LocationTracker locationTracker;
    private boolean shipsUpdated = false;

    @PostConstruct
    private void init() {
        this.clientServerEventBus.register((Object)this);
        this.timerEventBus.register((Object)this);
        this.syncServerClientEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregister() {
        this.clientServerEventBus.unregister((Object)this);
        this.timerEventBus.unregister((Object)this);
        this.syncServerClientEventBus.unregister((Object)this);
    }

    @Subscribe
    public void checkShipUpdate(ShipPositionUpdateEvent event) {
        this.shipsUpdated = true;
    }

    @VisibleForTesting
    void handleShipLocationUpdate() {
        for (MapSegmentedImage mapSegment : this.dataModel.getMapSegments()) {
            Point2D location = mapSegment.getLocation();
            List<INavigableVessel> shipsToCheck = this.locationTracker.getShipsInSegments(location, this.locationDistance);
            for (INavigableVessel ship : shipsToCheck) {
                if (!(location.distance(ship.getLocation()) <= (double)this.locationDistance) || this.dataModel.isInCheckedList(ship)) continue;
                DateTime dealine = this.date.getCurrentDate().plusDays(1);
                MapSegmentDataCheck check = new MapSegmentDataCheck(ship, mapSegment, dealine);
                this.dataModel.getCheckList().put(check.getShip(), check);
            }
        }
    }

    @Subscribe
    public void checkShipLeaving(ClockTick tick) {
        if (this.shipsUpdated) {
            this.handleShipLocationUpdate();
            this.shipsUpdated = false;
        }
        Iterator iterator = this.dataModel.getCheckList().keySet().iterator();
        while (iterator.hasNext()) {
            TargetedEvent displayMessage;
            DisplayMessage msg;
            int survivingShips;
            INavigableVessel ship = (INavigableVessel)iterator.next();
            MapSegmentDataCheck check = (MapSegmentDataCheck)this.dataModel.getCheckList().get(ship);
            if (ship.getLocation().distance(check.getMapSegment().getLocation()) > (double)this.locationDistance) {
                iterator.remove();
                continue;
            }
            DateTime now = this.date.getCurrentDate();
            if (!now.isAfter((ReadableInstant)check.getDeadline())) continue;
            iterator.remove();
            if (check.getMapSegment() instanceof TreasureMapSegmentImage) {
                TreasureMapSegmentImage treasureMap = (TreasureMapSegmentImage)check.getMapSegment();
                DisplayMessage msg2 = new DisplayMessage("ch.sahits.game.openpatrician.engine.sea.MapLocationDetector.treasure", new Object[]{treasureMap.getTreasureAmount()});
                TargetedEvent displayMessage2 = new TargetedEvent((IHumanPlayer)ship.getOwner(), (Object)msg2);
                this.clientServerEventBus.post((Object)displayMessage2);
                ((IPlayer)ship.getOwner()).getCompany().updateCash((long)treasureMap.getTreasureAmount());
                ((IPlayer)ship.getOwner()).setSegmentedMap(null);
                this.dataModel.removeSegment((MapSegmentedImage)treasureMap);
            }
            if (!(check.getMapSegment() instanceof PirateMapSegmentImage)) continue;
            PirateMapSegmentImage pirateNest = (PirateMapSegmentImage)check.getMapSegment();
            int pirateFortification = 1;
            if (ship instanceof IConvoy) {
                IConvoy convoy = (IConvoy)ship;
                int randomPirateDestroy = this.rnd.nextInt(1);
                survivingShips = convoy.getShips().size() - (pirateNest.getAmountOfShips() + pirateFortification - randomPirateDestroy);
            } else {
                int randomPirateDestroy = this.rnd.nextInt(1);
                int nbShips = 1;
                survivingShips = nbShips - (pirateNest.getAmountOfShips() + pirateFortification - randomPirateDestroy);
            }
            if (survivingShips > 0) {
                this.dataModel.removeSegment((MapSegmentedImage)pirateNest);
                msg = new DisplayMessage("ch.sahits.game.openpatrician.engine.sea.MapLocationDetector.pirateDefeated", new Object[]{pirateNest.getName()});
                displayMessage = new TargetedEvent((IHumanPlayer)ship.getOwner(), (Object)msg);
                this.clientServerEventBus.post((Object)displayMessage);
                if (ship instanceof IConvoy) {
                    this.removeDefeatedShips((IConvoy)ship, survivingShips);
                }
                List acceptedTasks = this.aldermanOffice.getWorkedOnTasks();
                Iterator taskIterator = acceptedTasks.iterator();
                while (taskIterator.hasNext()) {
                    IAcceptedAldermanTask task = (IAcceptedAldermanTask)taskIterator.next();
                    if (!task.getPlayer().equals(ship.getOwner()) || !(task.getTask() instanceof ICapturePirateNest) || !((ICapturePirateNest)task.getTask()).getPirateNestMap().equals((Object)pirateNest)) continue;
                    taskIterator.remove();
                    if (!task.getDeadline().isAfter((ReadableInstant)now)) continue;
                    for (ICity city : this.map.getCities()) {
                        IReputation reputation = city.getReputation((IPlayer)ship.getOwner());
                        reputation.update(150);
                    }
                }
                continue;
            }
            msg = new DisplayMessage("ch.sahits.game.openpatrician.engine.sea.MapLocationDetector.defeatedByPirate", new Object[]{pirateNest.getName()});
            displayMessage = new TargetedEvent((IHumanPlayer)ship.getOwner(), (Object)msg);
            this.clientServerEventBus.post((Object)displayMessage);
            if (ship instanceof IConvoy) {
                IConvoy convoy = (IConvoy)ship;
                this.removeDefeatedShips(convoy, 0);
                continue;
            }
            ((IPlayer)ship.getOwner()).getFleet().remove(ship);
        }
    }

    @VisibleForTesting
    void removeDefeatedShips(IConvoy ship, int survivingShips) {
        IConvoy convoy = ship;
        List ships = convoy.getShips();
        int destroyedShips = ships.size() - survivingShips;
        if (destroyedShips < ships.size()) {
            ships.remove(convoy.getOrlegShip());
            Collections.shuffle(ships);
        } else {
            ((IPlayer)convoy.getOwner()).getFleet().remove(convoy);
        }
        ArrayListMultimap destoyedShipsMap = ArrayListMultimap.create();
        while (destroyedShips > 0) {
            IShip s = (IShip)ships.get(destroyedShips - 1);
            destoyedShipsMap.put((Object)((IPlayer)s.getOwner()), (Object)s);
            convoy.removeShip(s);
            ((IPlayer)s.getOwner()).getFleet().remove(s);
            --destroyedShips;
        }
        for (IPlayer player : destoyedShipsMap.keySet()) {
            String messageKey;
            String titleKey;
            if (!(player instanceof IHumanPlayer)) continue;
            ArrayList destroyedShipsOfPlayer = new ArrayList(destoyedShipsMap.get((Object)player));
            if (destroyedShipsOfPlayer.size() > 1) {
                titleKey = "ch.sahits.game.openpatrician.engine.sea.MapLocationDetector.shiploss.manytitle";
                messageKey = "ch.sahits.game.openpatrician.engine.sea.MapLocationDetector.shiploss.manySunk";
                StringBuffer sunkenShips = new StringBuffer();
                for (int i = 0; i < destroyedShipsOfPlayer.size() - 1; ++i) {
                    IShip s = (IShip)destroyedShipsOfPlayer.get(i);
                    sunkenShips.append(s.getName());
                    if (i >= destroyedShipsOfPlayer.size() - 2) continue;
                    sunkenShips.append(", ");
                }
                String lastShipName = ((IShip)destroyedShipsOfPlayer.get(destroyedShipsOfPlayer.size() - 1)).getName();
                Object[] args = new Object[]{sunkenShips.toString(), lastShipName};
                DialogTemplate template = DialogTemplate.builder().closable(true).titleKey(titleKey).messageKey(messageKey).messageArgs(args).build();
                DisplayMessage message = new DisplayMessage(titleKey, template, new Object[0]);
                TargetedEvent tagetDisplayMsg = new TargetedEvent((IHumanPlayer)player, (Object)message);
                this.clientServerEventBus.post((Object)tagetDisplayMsg);
                continue;
            }
            titleKey = "ch.sahits.game.openpatrician.engine.sea.MapLocationDetector.shiploss.title";
            messageKey = "ch.sahits.game.openpatrician.engine.sea.MapLocationDetector.shiploss.oneSunk";
            String lastShipName = ((IShip)destroyedShipsOfPlayer.get(0)).getName();
            Object[] args = new Object[]{lastShipName};
            DialogTemplate template = DialogTemplate.builder().closable(true).titleKey(titleKey).messageKey(messageKey).messageArgs(args).build();
            DisplayMessage message = new DisplayMessage(titleKey, template, new Object[0]);
            TargetedEvent tagetDisplayMsg = new TargetedEvent((IHumanPlayer)player, (Object)message);
            this.clientServerEventBus.post((Object)tagetDisplayMsg);
        }
    }
}

