/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.sea.model;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.MapType;
import java.util.HashMap;
import java.util.Map;
import javafx.geometry.Point2D;

@ClassCategory(value={EClassCategory.MODEL})
public final class NodeData<T> {
    private final T nodeId;
    @MapType(key=Point2D.class, value=Double.class)
    private final Map<T, Double> heuristic;
    @MapType(key=Point2D.class, value=Double.class)
    private Map<T, Double> distanceFromSource = new HashMap<T, Double>();
    private double h;
    private double f;

    public NodeData(T nodeId, Map<T, Double> heuristic) {
        this.nodeId = nodeId;
        this.heuristic = heuristic;
    }

    public void setG(T source, double g) {
        this.distanceFromSource.put(source, g);
    }

    public double getG(T source) {
        if (this.distanceFromSource.containsKey(source)) {
            return this.distanceFromSource.get(source);
        }
        return Double.MAX_VALUE;
    }

    public void calcF(T destination, T source) {
        if (this.heuristic == null) {
            System.out.println("Heuristic is null");
        }
        if (this.heuristic.get(destination) == null) {
            System.out.println("Destination not available");
        }
        this.h = this.heuristic.get(destination);
        this.f = this.getG(source) + this.h;
    }

    public T getNodeId() {
        return this.nodeId;
    }

    public double getH() {
        return this.h;
    }

    public double getF() {
        return this.f;
    }
}

