package ch.sahits.game.openpatrician.engine;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.collections.SortedMapRandomizedSameElements;
import ch.sahits.game.openpatrician.engine.land.city.internal.AddViolationTask;
import ch.sahits.game.openpatrician.engine.land.city.internal.CityWallBuildingTask;
import ch.sahits.game.openpatrician.engine.land.city.internal.CityWallMaterialBuyingTask;
import ch.sahits.game.openpatrician.engine.land.city.internal.ElectionTask;
import ch.sahits.game.openpatrician.engine.land.city.internal.VoteTask;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityHall;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityViolation;
import ch.sahits.game.openpatrician.model.city.cityhall.IAldermanOffice;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.Ballot;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.Election;
import ch.sahits.game.openpatrician.model.city.impl.CityWall;
import ch.sahits.game.openpatrician.util.StartNewGameBean;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

/**
 * This abstraction layer for creating engines allows better decoupling and allows therefore easier testing.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 20, 2014
 */
@Service
@Lazy
@DependentInitialisation(StartNewGameBean.class)
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class EngineFactory {
    @Autowired
    private ApplicationContext context;



    public ElectionTask getNewElectionTask(SortedMapRandomizedSameElements candidates, Election result, DateTime executionTime) {
        return (ElectionTask) context.getBean("electionTask", new Object[]{candidates, result, executionTime});
    }

    public VoteTask getVoteTask(boolean yes, DateTime executionTime, Ballot result) {
        return (VoteTask) context.getBean("voteTask", result, executionTime, yes);
    }

    public CityWallBuildingTask getCityWallBuildingTask(CityWall cityWall, DateTime executionTime) {
        return (CityWallBuildingTask) context.getBean("cityWallBuildingTask", cityWall, executionTime);
    }
    public CityWallMaterialBuyingTask getCityWallBuyMaterialTask(ICityHall cityHall, DateTime executionTime){
        return (CityWallMaterialBuyingTask) context.getBean("cityWallMaterialBuyingTask", cityHall, executionTime);
    }
    public AddViolationTask getViolationTask(ICityViolation violation, IAldermanOffice office, DateTime executionTime) {
        return (AddViolationTask) context.getBean("addViolationTask", violation, office, executionTime);
    }
}
