package ch.sahits.game.openpatrician.engine.event.task;

import ch.sahits.game.event.data.RepairFinishedEvent;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.ship.IShip;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Feb 23, 2014
 */
@Component("aIRepairTask")
@Scope("prototype")
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
class AIRepairTask extends TimedTask {
    @Autowired
    @XStreamOmitField
    @Qualifier("serverClientEventBus")
    private AsyncEventBus clientServerEventBus;


    private final IShip ship;

    public AIRepairTask(DateTime executionTime, IShip ship) {
        super();
        setExecutionTime(executionTime);
        this.ship = ship;
    }

    @Override
    public void run() {
        ship.repair();
        ship.setAvailable(true);
        clientServerEventBus.post(new RepairFinishedEvent(ship));
    }
}
