package ch.sahits.game.openpatrician.engine.player;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.engine.sea.SeafaringService;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.model.product.ITradeStep;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import lombok.Setter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * Trade ste for traveling to a new location.
 */
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@Prototype
public class TravelToTradeStep implements ITradeStep {
    @XStreamOmitField
    private final Logger logger = LogManager.getLogger(getClass());
    @Setter
    private ICity destinationCity;
    @Setter
    private INavigableVessel vessel;
    @Autowired
    @XStreamOmitField
    private SeafaringService seafaringService;
    @Autowired
    private TimedUpdatableTaskList taskList;
    @Autowired
    private Date date;


    @Override
    public boolean execute() {
        if (vessel instanceof IConvoy) {
            IConvoy convoy = (IConvoy) vessel;
            if (convoy.isPublicConvoy()) {
                TimedTask task = new TimedTask() {
                    {
                        setExecutionTime(date.getCurrentDate().plusDays(5));
                    }
                    @Override
                    public void run() {
                        seafaringService.travelBetweenCities(vessel, destinationCity);
                    }
                };
                taskList.add(task);
            } else {
                seafaringService.travelBetweenCities(vessel, destinationCity);
            }
        } else {
            seafaringService.travelBetweenCities(vessel, destinationCity);
        }
        logger.trace("Ship {} travels from {} to {}", vessel.getName(), vessel.getLocation(), destinationCity.getCoordinates());
        return false;
    }

    @Override
    public String toString() {
        return "TravelToTradeStep to "+destinationCity.getName();
    }
}
