package ch.sahits.game.openpatrician.engine.player;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import com.google.common.base.Preconditions;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * Repair strategy to only repair in towns in the western half of the map.
 */
@ClassCategory(EClassCategory.SINGLETON_BEAN)
@LazySingleton
public class WestRepairStrategy extends BaseRepairStrategy{
    @Autowired
    private IMap map;

    /**
     * Should repair only if deamage is heavy or if the ship is in a city in the
     * west half of the map.
     * @param vessel that should be checked for repair need.
     * @param city current possition of the vessel.
     * @return
     */
    @Override
    public boolean shouldRepair(INavigableVessel vessel, ICity city) {
        Preconditions.checkArgument(vessel.getLocation().equals(city.getCoordinates()), "The vessel is not in city "+city.getName()+" but at "+vessel.getLocation());
        int damage = vessel.getDamage();
        if (damage > 90) {
            return true;
        }
        double width = map.getDimension().getWidth();
        if (city.getCoordinates().getX() < width/2) {
            return true;
        }
        return false;
    }
}
