package ch.sahits.game.openpatrician.engine.sea;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.sea.IBlockade;
import lombok.EqualsAndHashCode;
import lombok.Getter;

/**
 * Sea fight context for the blockade.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Apr 26, 2016
 */
@ClassCategory({EClassCategory.MODEL, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
@EqualsAndHashCode
public class BlockadeSeafightContext  extends SeaFightContext {
    @Getter
    private final IBlockade blockade;

    public BlockadeSeafightContext(IBlockade blockade) {
        super(ESeaFightType.BLOCKADE);
        this.blockade = blockade;
    }
}
