package ch.sahits.game.openpatrician.engine.time;

import ch.sahits.game.event.data.ClockTick;

/**
 * Interface for periodical updates that are individualized as they define the start time.
 * Multiple objects can register with this listener. Once an update is sent it is sent to
 * all registered objects, however the intended target is part of the message. The reciever
 * has to check if the message is addressed to them.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 23, 2014
 */
public interface IIndividualPeriodicalUpdater {
    /**
     * Register a new object with the updater. <code>period</code> time after
     * the registration an update with the target as addressee is sent.
     * @param addresse the object which handels the updates.
     * @param target which registers an updater
     * @param period update period.
     */
    void register(Object addresse, Object target, EUpdateIntervalRegistration period);

    /**
     * Unregister a target from further notifications.
     * @param target to be unregistered.
     */
    void unregister(Object target);

    /**
     * Method handling the external events of a clock tick.
     * @param event object.
     */
    void handleClockTick(ClockTick event);

}
