/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.event.task;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.engine.event.task.AIRepairTask;
import ch.sahits.game.openpatrician.engine.event.task.RefitShipTask;
import ch.sahits.game.openpatrician.engine.event.task.RepairPirateShipTask;
import ch.sahits.game.openpatrician.engine.event.task.RepairTask;
import ch.sahits.game.openpatrician.engine.event.task.ShipBuildTask;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.impl.IShipBuildTask;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.people.ISeaPirate;
import ch.sahits.game.openpatrician.model.ship.EShipType;
import ch.sahits.game.openpatrician.model.ship.EShipUpgrade;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.util.StartNewGameBean;
import javafx.geometry.Point2D;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy
@DependentInitialisation(value=StartNewGameBean.class)
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class ServerSideTaskFactory {
    @Autowired
    private ApplicationContext context;

    public TimedTask getRepairTask(DateTime executionTime, IShip ship, ICityPlayerProxyJFX proxy) {
        Object[] args = new Object[]{executionTime, ship, proxy};
        return (RepairTask)((Object)this.context.getBean("repairTask", args));
    }

    public IShipBuildTask getShipBuildTask(DateTime executionTime, EShipType type, IPlayer owner, Point2D location) {
        Object[] args = new Object[]{executionTime, type, owner, location};
        return (ShipBuildTask)((Object)this.context.getBean("shipBuildTask", args));
    }

    public TimedTask getRefitShipTask(DateTime executionTime, IShip ship, EShipUpgrade upgrade, ICityPlayerProxyJFX proxy) {
        Object[] args = new Object[]{executionTime, ship, upgrade, proxy};
        return (RefitShipTask)((Object)this.context.getBean("refitShipTask", args));
    }

    public TimedTask getPirateRepairTask(DateTime dueDate, INavigableVessel vessel, ISeaPirate owner) {
        Object[] args = new Object[]{dueDate, vessel, owner};
        return (RepairPirateShipTask)((Object)this.context.getBean("repairPirateShipTask", args));
    }

    public TimedTask getAIShipRepairTask(DateTime dueDate, IShip ship) {
        Object[] args = new Object[]{dueDate, ship};
        return (AIRepairTask)((Object)this.context.getBean("aIRepairTask", args));
    }
}

