/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.event.task;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.clientserverinterface.model.factory.ShipFactory;
import ch.sahits.game.openpatrician.engine.sea.LocationTracker;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.impl.IShipBuildTask;
import ch.sahits.game.openpatrician.model.event.TargetedEvent;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.people.IShipOwner;
import ch.sahits.game.openpatrician.model.ship.EShipType;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.ship.ISnaikka;
import ch.sahits.game.openpatrician.util.RandomNameLoader;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import javafx.geometry.Point2D;
import javax.annotation.PostConstruct;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
class ShipBuildTask
extends TimedTask
implements IShipBuildTask {
    private final EShipType type;
    private final IPlayer owner;
    @Autowired
    @XStreamOmitField
    private ShipFactory shipUtility;
    private final double x;
    private final Point2D location;
    private IShip ship;
    private static RandomNameLoader shipLoader = new RandomNameLoader("shipnames.properties");
    @Autowired
    @XStreamOmitField
    private Locale locale;
    @Autowired
    @XStreamOmitField
    private MessageSource messageSource;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientServerEventBus;
    @Autowired
    private LocationTracker locationTracker;

    public ShipBuildTask(DateTime executionTime, EShipType type, IPlayer owner, Point2D location) {
        this.setExecutionTime(executionTime);
        this.owner = owner;
        this.type = type;
        this.x = location.getX();
        this.location = location;
    }

    @PostConstruct
    void initializeShip() {
        this.ship = this.createShip();
    }

    public void run() {
        this.ship.setLocation(this.location);
        this.locationTracker.add((INavigableVessel)this.ship);
        if (this.owner instanceof IHumanPlayer) {
            DisplayMessage msg = new DisplayMessage("ch.sahits.game.openpatrician.engine.event.task.ShipBuildTask.message", new Object[]{this.type, this.ship.getName()});
            TargetedEvent displayMessage = new TargetedEvent((IHumanPlayer)this.owner, (Object)msg);
            this.clientServerEventBus.post((Object)displayMessage);
        }
    }

    public IShip getShipToBeBuilt() {
        return this.ship;
    }

    private IShip createShip() {
        ISnaikka ship = null;
        switch (this.type) {
            case SNAIKKA: {
                ship = this.shipUtility.createSnaikka(shipLoader.getRandomName(), this.calculateShipCapacity());
                break;
            }
            case CRAYER: {
                ship = this.shipUtility.createCrayer(shipLoader.getRandomName(), this.calculateShipCapacity());
                break;
            }
            case COG: {
                ship = this.shipUtility.createCog(shipLoader.getRandomName(), this.calculateShipCapacity());
                break;
            }
            case HOLK: {
                ship = this.shipUtility.createHolk(shipLoader.getRandomName(), this.calculateShipCapacity());
            }
        }
        ship.setOwner((IShipOwner)this.owner);
        return ship;
    }

    private int calculateShipCapacity() {
        return this.shipUtility.calculateInitialCapacity(this.type, (double)((int)this.x));
    }
}

