/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.land.city;

import ch.sahits.game.event.data.ElectionWinnerNotification;
import ch.sahits.game.event.data.NewGameClient;
import ch.sahits.game.event.data.PeriodicalTimeDayUpdate;
import ch.sahits.game.event.data.PeriodicalTimeMonthEndUpdate;
import ch.sahits.game.event.data.PeriodicalTimeWeekEndUpdate;
import ch.sahits.game.event.data.PeriodicalTimeYearEndUpdate;
import ch.sahits.game.event.data.ShipAttackEvent;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.clientserverinterface.model.factory.PeopleFactory;
import ch.sahits.game.openpatrician.clientserverinterface.model.factory.StateFactory;
import ch.sahits.game.openpatrician.clientserverinterface.service.LoanerService;
import ch.sahits.game.openpatrician.clientserverinterface.service.MapService;
import ch.sahits.game.openpatrician.collections.SortedMapRandomizedSameElements;
import ch.sahits.game.openpatrician.engine.AbstractEngine;
import ch.sahits.game.openpatrician.engine.EngineFactory;
import ch.sahits.game.openpatrician.engine.land.city.LoanerEngine;
import ch.sahits.game.openpatrician.engine.land.city.internal.CityWallMaterialBuyingTask;
import ch.sahits.game.openpatrician.engine.land.city.internal.ElectionTask;
import ch.sahits.game.openpatrician.engine.land.city.internal.VoteTask;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.DateService;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.ICompany;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.IBarn;
import ch.sahits.game.openpatrician.model.building.IBuilding;
import ch.sahits.game.openpatrician.model.building.ICityHall;
import ch.sahits.game.openpatrician.model.building.ICityWall;
import ch.sahits.game.openpatrician.model.building.IMarketplace;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.ECityWall;
import ch.sahits.game.openpatrician.model.city.EPopulationClass;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.ICreditor;
import ch.sahits.game.openpatrician.model.city.ILoaner;
import ch.sahits.game.openpatrician.model.city.cityhall.AldermanCandidateList;
import ch.sahits.game.openpatrician.model.city.cityhall.AldermanTaskPlayerMap;
import ch.sahits.game.openpatrician.model.city.cityhall.CityHallList;
import ch.sahits.game.openpatrician.model.city.cityhall.ECityViolationPunishment;
import ch.sahits.game.openpatrician.model.city.cityhall.EElectionType;
import ch.sahits.game.openpatrician.model.city.cityhall.IAcceptedAldermanTask;
import ch.sahits.game.openpatrician.model.city.cityhall.IAldermanOffice;
import ch.sahits.game.openpatrician.model.city.cityhall.IAldermanTask;
import ch.sahits.game.openpatrician.model.city.cityhall.IBowmen;
import ch.sahits.game.openpatrician.model.city.cityhall.IBuildLandPassage;
import ch.sahits.game.openpatrician.model.city.cityhall.ICapturePirateNest;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityGuard;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityPetition;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityViolation;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityWallPetition;
import ch.sahits.game.openpatrician.model.city.cityhall.ICrossbowmen;
import ch.sahits.game.openpatrician.model.city.cityhall.ICustomsViolation;
import ch.sahits.game.openpatrician.model.city.cityhall.IFoundNewSettlement;
import ch.sahits.game.openpatrician.model.city.cityhall.IHeadTaxPetition;
import ch.sahits.game.openpatrician.model.city.cityhall.IHelpCity;
import ch.sahits.game.openpatrician.model.city.cityhall.IHuntPirate;
import ch.sahits.game.openpatrician.model.city.cityhall.IMilitiaPetition;
import ch.sahits.game.openpatrician.model.city.cityhall.IMusketeer;
import ch.sahits.game.openpatrician.model.city.cityhall.IOutriggerContract;
import ch.sahits.game.openpatrician.model.city.cityhall.IPikemen;
import ch.sahits.game.openpatrician.model.city.cityhall.IPirateSupportViolation;
import ch.sahits.game.openpatrician.model.city.cityhall.IPlunderTradingOfficesViolation;
import ch.sahits.game.openpatrician.model.city.cityhall.ISpecialTaxPetition;
import ch.sahits.game.openpatrician.model.city.cityhall.ISpecialTaxViolation;
import ch.sahits.game.openpatrician.model.city.cityhall.ITreasury;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.AldermanOffice;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.Ballot;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.CityHall;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.CityViolation;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.CustomsViolation;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.Election;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.PlunderTradingOfficeViolation;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.SpecialTaxPetition;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.SpecialTaxViolation;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.Treasury;
import ch.sahits.game.openpatrician.model.city.impl.CityWall;
import ch.sahits.game.openpatrician.model.city.impl.Debt;
import ch.sahits.game.openpatrician.model.city.impl.IDebt;
import ch.sahits.game.openpatrician.model.event.TargetedEvent;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.model.impl.BalanceSheet;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.model.people.ISeaPirate;
import ch.sahits.game.openpatrician.model.people.impl.SeaPiratesState;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.sea.PirateNest;
import ch.sahits.game.openpatrician.spring.DependentAnnotationConfigApplicationContext;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class CityHallEngine
extends AbstractEngine {
    private final Logger logger = LogManager.getLogger(this.getClass());
    @Value(value="${headtax.weekly.poor}")
    private double weeklyHeadTaxPoor = 0.0;
    @Value(value="${headtax.weekly.middle}")
    private double weeklyHeadTaxMiddleClass = 0.6;
    @Value(value="${headtax.weekly.rich}")
    private double weeklyHeadTaxRich = 2.0;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    private StateFactory stateFactory;
    @Autowired
    private Random rnd;
    @Autowired
    private Date date;
    @Autowired
    private MapService citiesInteractionService;
    @Autowired
    private IMap map;
    @Autowired
    private SeaPiratesState pirateState;
    @Autowired
    private LoanerEngine loanerEngine;
    @Autowired
    private EngineFactory engineFactory;
    @Autowired
    private PeopleFactory peopleFactory;
    @Autowired
    private TimedUpdatableTaskList timedTaskListener;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private AldermanCandidateList aldermanCandidates;
    @Autowired
    private CityHallList cityHalls;
    private CityInitialisation initialisation = new CityInitialisation();
    @Autowired
    private AldermanTaskPlayerMap takenTasks;
    @Autowired
    private AldermanOffice aldermanOffice;
    @Autowired
    private DependentAnnotationConfigApplicationContext context;
    @Autowired
    private DateService dateService;
    @Autowired
    private LoanerService loanerService;

    @PostConstruct
    private void init() {
        this.clientServerEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregister() {
        this.clientServerEventBus.unregister((Object)this);
    }

    @Subscribe
    public void handleWeeklyUpdate(PeriodicalTimeWeekEndUpdate event) {
        for (ch.sahits.game.openpatrician.model.city.cityhall.ICityHall cityHall : this.cityHalls) {
            this.updateTreasuryWeekly(cityHall);
            ObservableList newNotices = this.citiesInteractionService.createNotices(cityHall.getCity());
            ObservableList noticesToBeRemoved = cityHall.getNotices();
            noticesToBeRemoved.stream().forEach(notice -> {
                this.context.removePrototypeBean((Object)notice.getContact());
                this.context.removePrototypeBean(notice);
            });
            noticesToBeRemoved.clear();
            noticesToBeRemoved.addAll(newNotices);
            this.checkPetitions(cityHall);
            if (!cityHall.getAldermanOffice().isPresent()) continue;
            this.checkTasksFinished((IAldermanOffice)cityHall.getAldermanOffice().get());
            this.checkViolations((IAldermanOffice)cityHall.getAldermanOffice().get(), cityHall.getAlderman(), cityHall);
        }
    }

    private void checkPetitions(ch.sahits.game.openpatrician.model.city.cityhall.ICityHall cityHall) {
        int random;
        ITreasury treasury;
        if (cityHall.getPetition().isPresent()) {
            DateTime meeting = this.date.getCurrentDate().plusDays(20 + this.rnd.nextInt(40));
            ((CityHall)cityHall).setNextCouncilMeeting(Optional.of(meeting));
        }
        if ((treasury = cityHall.getTreasury()).getCash() < 1000L && (random = this.rnd.nextInt(10)) == 0) {
            DateTime deadline;
            SpecialTaxViolation violation;
            IAldermanOffice office = this.getAldermanOffice();
            random = this.rnd.nextInt(3);
            ICity city = cityHall.getCity();
            if (random == 0) {
                violation = new SpecialTaxViolation(city, this.date.getCurrentDate());
                deadline = this.date.getCurrentDate().plusDays(this.rnd.nextInt(50));
                this.engineFactory.getViolationTask((ICityViolation)violation, office, deadline);
                this.leveySpecialTax(cityHall, (ISpecialTaxPetition)new SpecialTaxPetition(20000));
            }
            if (random == 1) {
                violation = new CustomsViolation(city, this.date.getCurrentDate());
                deadline = this.date.getCurrentDate().plusDays(this.rnd.nextInt(50));
                this.engineFactory.getViolationTask((ICityViolation)violation, office, deadline);
            }
            if (random == 2) {
                violation = new PlunderTradingOfficeViolation(city, this.date.getCurrentDate());
                deadline = this.date.getCurrentDate().plusDays(this.rnd.nextInt(50));
                this.engineFactory.getViolationTask((ICityViolation)violation, office, deadline);
                List buildings = city.findBuilding(ITradingOffice.class, Optional.empty());
                for (ITradingOffice trOffice : buildings) {
                    for (EWare ware : EWare.values()) {
                        AmountablePrice amountable = trOffice.getWare((IWare)ware);
                        trOffice.move((IWare)ware, -amountable.getAmount());
                        city.move((IWare)ware, amountable.getAmount(), cityHall.getMayor());
                    }
                }
            }
        }
    }

    private void checkViolations(IAldermanOffice office, ICitizen alderman, ch.sahits.game.openpatrician.model.city.cityhall.ICityHall cityHall) {
        if (office.getViolation().isPresent()) {
            CityViolation violation = (CityViolation)office.getViolation().get();
            if (alderman instanceof IHumanPlayer) {
                if (violation.getDate().plusMonths(2).isBefore((ReadableInstant)this.date.getCurrentDate()) && violation.getPunishment() == null) {
                    DisplayMessage msg = new DisplayMessage("ch.sahits.game.openpatrician.engine.land.city.CityHallEngine.missedViolation", new Object[]{violation.getCity().getName()});
                    TargetedEvent displayMessage = new TargetedEvent((IHumanPlayer)alderman, (Object)msg);
                    this.clientServerEventBus.post((Object)displayMessage);
                    for (ICity city : this.map.getCities()) {
                        city.getReputation((IPlayer)alderman).update(-10);
                    }
                    ((AldermanOffice)office).setViolation(Optional.empty());
                }
                return;
            }
            if (alderman instanceof IAIPlayer && violation.getDate().plusMonths(2).isBefore((ReadableInstant)this.date.getCurrentDate()) && violation.getPunishment() == null) {
                for (ICity city : this.map.getCities()) {
                    city.getReputation((IPlayer)alderman).update(-10);
                }
            }
            if (violation.getDate().plusMonths(2).isBefore((ReadableInstant)this.date.getCurrentDate()) && violation.getPunishment() == null) {
                ((AldermanOffice)office).setViolation(Optional.empty());
            }
            if (!violation.getDate().plusMonths(2).isBefore((ReadableInstant)this.date.getCurrentDate())) {
                if (alderman.getHometown().equals(violation.getCity())) {
                    violation.setPunishment(ECityViolationPunishment.NONE);
                } else {
                    int index = this.rnd.nextInt(ECityViolationPunishment.values().length);
                    violation.setPunishment(ECityViolationPunishment.values()[index]);
                }
                DateTime meeting = this.date.getCurrentDate().plusDays(20 + this.rnd.nextInt(40));
                ((CityHall)cityHall).setHanseaticMeetingDate(Optional.of(meeting));
            }
        }
    }

    private void checkTasksFinished(IAldermanOffice office) {
        List tasks = office.getWorkedOnTasks();
        DateTime now = this.date.getCurrentDate();
        Iterator iterator = tasks.iterator();
        while (iterator.hasNext()) {
            IHelpCity concreteTask;
            ICity city;
            IAcceptedAldermanTask task = (IAcceptedAldermanTask)iterator.next();
            boolean updateStanding = false;
            if (now.isBefore((ReadableInstant)task.getDeadline())) {
                updateStanding = true;
            }
            if (task.getTask() instanceof IHelpCity && (city = (concreteTask = (IHelpCity)task.getTask()).getCity()).getPopulationBinding().get() >= 2000) {
                if (updateStanding) {
                    for (ICity iCity : this.map.getCities()) {
                        if (iCity.equals(city)) {
                            iCity.getReputation(task.getPlayer()).update(50);
                            continue;
                        }
                        iCity.getReputation(task.getPlayer()).update(20);
                    }
                }
                iterator.remove();
            }
            if (task.getTask() instanceof IBuildLandPassage) {
                concreteTask = (IBuildLandPassage)task.getTask();
                ICity city1 = concreteTask.getFromCity();
                ICity city2 = concreteTask.getToCity();
                if (!city1.findBuilding(IBarn.class, Optional.empty()).isEmpty() && !city2.findBuilding(IBarn.class, Optional.empty()).isEmpty()) {
                    if (updateStanding) {
                        for (ICity iCity : this.map.getCities()) {
                            if (iCity.equals(city1)) {
                                iCity.getReputation(task.getPlayer()).update(70);
                                continue;
                            }
                            if (iCity.equals(city2)) {
                                iCity.getReputation(task.getPlayer()).update(70);
                                continue;
                            }
                            iCity.getReputation(task.getPlayer()).update(35);
                        }
                    }
                    iterator.remove();
                }
            }
            if (task.getTask() instanceof IFoundNewSettlement) {
                concreteTask = (IFoundNewSettlement)task.getTask();
                city = this.map.findCity(concreteTask.getName());
                Optional absent = Optional.empty();
                if (!(city.getPopulationBinding().get() <= 1000 || city.findBuilding(ICityWall.class, absent).isEmpty() || city.findBuilding(IMarketplace.class, absent).isEmpty() || city.findBuilding(ICityHall.class, absent).isEmpty() || city.findBuilding(ITradingOffice.class, Optional.of(task.getPlayer())).isEmpty())) {
                    if (updateStanding) {
                        for (ICity iCity : this.map.getCities()) {
                            if (iCity.equals(city)) {
                                iCity.getReputation(task.getPlayer()).update(200);
                                continue;
                            }
                            iCity.getReputation(task.getPlayer()).update(100);
                        }
                    }
                    iterator.remove();
                }
            }
            if (!(task.getTask() instanceof ICapturePirateNest)) continue;
            concreteTask = (ICapturePirateNest)task.getTask();
            for (PirateNest pirateNest : this.map.getPirateNests()) {
                if (!pirateNest.getLocation().equals((Object)concreteTask.getLocation()) || !pirateNest.getDefendingShips().isEmpty()) continue;
                if (updateStanding) {
                    for (ICity iCity : this.map.getCities()) {
                        iCity.getReputation(task.getPlayer()).update(80);
                    }
                }
                iterator.remove();
            }
        }
    }

    @Subscribe
    public void handleDailyUpdate(PeriodicalTimeDayUpdate event) {
        for (ch.sahits.game.openpatrician.model.city.cityhall.ICityHall cityHall : this.cityHalls) {
            if (cityHall.getBallotResult().isPresent()) {
                Ballot result = (Ballot)cityHall.getBallotResult().get();
                if (result.getPetition() != null) {
                    ICityPetition petition = result.getPetition();
                    if (result.getNumberNo() > result.getNumberYes()) {
                        this.handleDeniedCityPetition(cityHall, petition);
                    } else {
                        this.handleAcceptedCityPetition(cityHall, petition);
                    }
                    ((CityHall)cityHall).setBallotResult(Optional.empty());
                    ((CityHall)cityHall).setNextCouncilMeeting(Optional.empty());
                } else {
                    ICityViolation violation = result.getViolation();
                    if (result.getNumberNo() > result.getNumberYes()) {
                        this.handleDeniedCityViolation(violation);
                    } else {
                        this.handleCityViolationPunishment(violation);
                    }
                    ((CityHall)cityHall).setBallotResult(Optional.empty());
                    ((CityHall)cityHall).setHanseaticMeetingDate(Optional.empty());
                }
            }
            if (cityHall.getElectionResult().isPresent()) {
                this.notificationElectionWinner(cityHall);
            }
            if (this.dateService.isToday(cityHall.getElectionDate())) {
                this.electNewMayor(cityHall);
                continue;
            }
            if (cityHall.getAldermanOffice().isPresent() && this.dateService.isToday(cityHall.getAldermanElectionDate())) {
                this.electNewAlderman(cityHall);
                continue;
            }
            if (cityHall.getNextCouncilMeeting().isPresent() && cityHall.getPetition().isPresent() && this.dateService.isToday((DateTime)cityHall.getNextCouncilMeeting().get())) {
                this.voteOnPetition(cityHall);
                continue;
            }
            if (!cityHall.getAldermanOffice().isPresent() || !cityHall.getHanseaticMeetingDate().isPresent() || !((IAldermanOffice)cityHall.getAldermanOffice().get()).getViolation().isPresent() || !this.dateService.isToday((DateTime)cityHall.getHanseaticMeetingDate().get())) continue;
            this.voteOnViolation(cityHall);
        }
    }

    private void voteOnViolation(ch.sahits.game.openpatrician.model.city.cityhall.ICityHall cityHall) {
        DateTime now = this.date.getCurrentDate();
        ICityViolation violation = (ICityViolation)((IAldermanOffice)cityHall.getAldermanOffice().get()).getViolation().get();
        Ballot result = new Ballot(violation);
        ((CityHall)cityHall).setBallotResult(Optional.of(result));
        int votingTimeFrame = 1080;
        for (ICity city : this.map.getCities()) {
            int limit;
            ch.sahits.game.openpatrician.model.city.cityhall.ICityHall ch = this.findCityHall(city);
            ICitizen mayor = ch.getMayor();
            if (mayor instanceof IHumanPlayer) continue;
            DateTime executionTime = now.plusMinutes(this.rnd.nextInt(votingTimeFrame));
            int random = this.rnd.nextInt(100);
            boolean yes = random <= (limit = this.getLimit(city, violation));
            VoteTask task = this.engineFactory.getVoteTask(yes, executionTime, result);
            this.timedTaskListener.add((TimedTask)task);
        }
    }

    private void voteOnPetition(ch.sahits.game.openpatrician.model.city.cityhall.ICityHall cityHall) {
        DateTime now = this.date.getCurrentDate();
        ICityPetition petition = (ICityPetition)cityHall.getPetition().get();
        Ballot result = new Ballot(petition);
        ((CityHall)cityHall).setBallotResult(Optional.of(result));
        List councilmen = cityHall.getCouncilmen();
        int votingTimeFrame = 1080;
        for (ICitizen citizen : councilmen) {
            int limit;
            if (citizen instanceof IHumanPlayer) continue;
            DateTime executionTime = now.plusMinutes(this.rnd.nextInt(votingTimeFrame));
            int random = this.rnd.nextInt(100);
            boolean yes = random <= (limit = this.getLimit(cityHall, petition));
            VoteTask task = this.engineFactory.getVoteTask(yes, executionTime, result);
            this.timedTaskListener.add((TimedTask)task);
        }
    }

    private int getLimit(ch.sahits.game.openpatrician.model.city.cityhall.ICityHall cityHall, ICityPetition petition) {
        if (petition instanceof ICityWallPetition) {
            int population = cityHall.getCity().getPopulationBinding().get();
            ECityWall cityWall = cityHall.getCity().getCityState().getCityWall().getExtension();
            switch (cityWall) {
                case NOT_EXTENDED: {
                    if (population < 8000) {
                        return 70;
                    }
                    if (population < 15000) {
                        return 95;
                    }
                    return 100;
                }
                case EXTENDED_ONCE: {
                    if (population < 8000) {
                        return -1;
                    }
                    if (population < 15000) {
                        return 70;
                    }
                    return 95;
                }
                case EXTENDED_TWICE: {
                    if (population < 8000) {
                        return -1;
                    }
                    if (population < 15000) {
                        return -1;
                    }
                    return -1;
                }
            }
        } else {
            if (petition instanceof IHeadTaxPetition) {
                long cash = cityHall.getTreasury().getCash();
                double currentHeadTax = cityHall.getTreasury().getCurrentHeadTaxValue();
                if (cash < 10000L) {
                    if (((IHeadTaxPetition)petition).getNewTaxValue() > currentHeadTax) {
                        return 60;
                    }
                    if (cash < 5000L) {
                        return 20;
                    }
                    return 50;
                }
                if (((IHeadTaxPetition)petition).getNewTaxValue() > currentHeadTax) {
                    return 0;
                }
                return 60;
            }
            if (petition instanceof IMilitiaPetition) {
                int nbGuards;
                int population = cityHall.getCity().getPopulationBinding().get();
                if (population / 100 >= (nbGuards = cityHall.getMaxNumberMilita()) + 5) {
                    return 70;
                }
                if (population / 100 >= nbGuards) {
                    return 55;
                }
                return 30;
            }
            if (petition instanceof ISpecialTaxPetition) {
                long cash = cityHall.getTreasury().getCash();
                if (cash < 2000L) {
                    return 65;
                }
                if (cash < 5000L) {
                    return 50;
                }
                return 20;
            }
        }
        return -1;
    }

    private int getLimit(ICity city, ICityViolation violation) {
        if (city.equals(violation.getCity())) {
            if (violation.getPunishment() == ECityViolationPunishment.NONE) {
                return 100;
            }
            return -1;
        }
        if (violation instanceof ICustomsViolation) {
            switch (violation.getPunishment()) {
                case NONE: {
                    return 10;
                }
                case SMALL_FINE: {
                    return 100;
                }
                case MEDIUM_FINE: {
                    return 65;
                }
                case LARGE_FINE: {
                    return 45;
                }
                case BLOCKADE: {
                    return 15;
                }
            }
        } else if (violation instanceof IPirateSupportViolation) {
            switch (violation.getPunishment()) {
                case NONE: {
                    return 15;
                }
                case SMALL_FINE: {
                    return 100;
                }
                case MEDIUM_FINE: {
                    return 85;
                }
                case LARGE_FINE: {
                    return 70;
                }
                case BLOCKADE: {
                    return 40;
                }
            }
        } else if (violation instanceof IPlunderTradingOfficesViolation) {
            switch (violation.getPunishment()) {
                case NONE: {
                    return 10;
                }
                case SMALL_FINE: {
                    return 100;
                }
                case MEDIUM_FINE: {
                    return 95;
                }
                case LARGE_FINE: {
                    return 90;
                }
                case BLOCKADE: {
                    return 70;
                }
            }
        } else if (violation instanceof SpecialTaxViolation) {
            switch (violation.getPunishment()) {
                case NONE: {
                    return 8;
                }
                case SMALL_FINE: {
                    return 100;
                }
                case MEDIUM_FINE: {
                    return 90;
                }
                case LARGE_FINE: {
                    return 65;
                }
                case BLOCKADE: {
                    return 15;
                }
            }
        }
        return -1;
    }

    private void electNewAlderman(ch.sahits.game.openpatrician.model.city.cityhall.ICityHall cityHall) {
        Election electionResult = new Election(EElectionType.ALDERMAN);
        ((CityHall)cityHall).setElectionResult(Optional.of(electionResult));
        DateTime now = this.date.getCurrentDate();
        int hourOfDay = now.getHourOfDay();
        int votingTimeFrame = (24 - hourOfDay) * 60;
        for (ICity city : this.map.getCities()) {
            ch.sahits.game.openpatrician.model.city.cityhall.ICityHall ch = this.findCityHall(city);
            ICitizen mayor = ch.getMayor();
            if (mayor instanceof IHumanPlayer) continue;
            AldermanCandidateList aldermanCandidates = cityHall.getAldermanCandidates();
            SortedMapRandomizedSameElements mappedCandidates = this.citiesInteractionService.getCandidateMap(aldermanCandidates.getAll(), city);
            DateTime executionTime = now.plusMinutes(this.rnd.nextInt(votingTimeFrame));
            ElectionTask task = this.engineFactory.getNewElectionTask(mappedCandidates, electionResult, executionTime);
            this.timedTaskListener.add((TimedTask)task);
        }
    }

    private void electNewMayor(ch.sahits.game.openpatrician.model.city.cityhall.ICityHall cityHall) {
        SortedMapRandomizedSameElements mappedCandidates = this.citiesInteractionService.getCandidateMap(cityHall.getCandidates(), cityHall.getCity());
        Election electionResult = new Election(EElectionType.MAYORAL);
        ((CityHall)cityHall).setElectionResult(Optional.of(electionResult));
        DateTime now = this.date.getCurrentDate();
        List councilmen = cityHall.getCouncilmen();
        int hourOfDay = now.getHourOfDay();
        int votingTimeFrame = (23 - hourOfDay) * 60;
        for (ICitizen citizen : councilmen) {
            if (citizen instanceof IPlayer && !(citizen instanceof IAIPlayer)) continue;
            DateTime executionTime = now.plusMinutes(this.rnd.nextInt(votingTimeFrame));
            ElectionTask task = this.engineFactory.getNewElectionTask(mappedCandidates, electionResult, executionTime);
            this.logger.debug("Created election task to be executed on {} created at {}", new Object[]{executionTime, now});
            this.timedTaskListener.add((TimedTask)task);
        }
    }

    private void notificationElectionWinner(ch.sahits.game.openpatrician.model.city.cityhall.ICityHall cityHall) {
        DateTime newDate = this.date.getCurrentDate().plusYears(2).minusDays(1);
        Election result = (Election)cityHall.getElectionResult().get();
        ICitizen winner = null;
        int maxVotes = 0;
        for (Map.Entry entry : result.getVotes().entrySet()) {
            if ((Integer)entry.getValue() <= maxVotes) continue;
            winner = (ICitizen)entry.getKey();
            maxVotes = (Integer)entry.getValue();
        }
        this.logger.debug("Inform the election winner at {}", new Object[]{this.date.getCurrentDate()});
        if (winner != null) {
            String name = winner.getName() + " " + winner.getLastName();
            switch (result.getType()) {
                case MAYORAL: {
                    DisplayMessage msg = new DisplayMessage("ch.sahits.game.openpatrician.engine.land.city.CityHallEngine.mayoralElectionResult", new Object[]{cityHall.getCity().getName(), name});
                    this.clientServerEventBus.post((Object)msg);
                    ((CityHall)cityHall).setMayor(winner);
                    ((CityHall)cityHall).setElectionDate(newDate);
                    this.clientServerEventBus.post((Object)new ElectionWinnerNotification(EElectionType.MAYORAL, cityHall.getCity()));
                    break;
                }
                case ALDERMAN: {
                    DisplayMessage msg = new DisplayMessage("ch.sahits.game.openpatrician.engine.land.city.CityHallEngine.aldermanElectionResult", new Object[]{cityHall.getCity().getName(), name});
                    this.clientServerEventBus.post((Object)msg);
                    ((CityHall)cityHall).setAlderman(winner);
                    for (ch.sahits.game.openpatrician.model.city.cityhall.ICityHall hall : this.cityHalls) {
                        ((CityHall)hall).setAldermanElectionDate(newDate);
                    }
                    this.clientServerEventBus.post((Object)new ElectionWinnerNotification(EElectionType.ALDERMAN, cityHall.getCity()));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown election type: " + result.getType());
                }
            }
            ((CityHall)cityHall).setElectionResult(Optional.empty());
        }
    }

    private void handleCityViolationPunishment(ICityViolation violation) {
        ECityViolationPunishment punishment = violation.getPunishment();
        DisplayMessage msg = null;
        if (punishment == ECityViolationPunishment.NONE) {
            msg = new DisplayMessage("ch.sahits.game.openpatrician.engine.land.city.CityHallEngine.yesViolationNoAction", new Object[]{violation.getCity().getName()});
        } else if (punishment == ECityViolationPunishment.BLOCKADE) {
            msg = new DisplayMessage("ch.sahits.game.openpatrician.engine.land.city.CityHallEngine.yesViolationBlockade", new Object[]{violation.getCity().getName()});
            this.initializeBlockadeAction(violation.getCity());
        } else {
            ICity otherCity = violation.getCity();
            ch.sahits.game.openpatrician.model.city.cityhall.ICityHall otherCityHall = this.findCityHall(otherCity);
            Treasury otherTreasury = (Treasury)otherCityHall.getTreasury();
            int fine = this.citiesInteractionService.getFine(punishment, (ITreasury)otherTreasury);
            msg = new DisplayMessage("ch.sahits.game.openpatrician.engine.land.city.CityHallEngine.yesViolationFine", new Object[]{violation.getCity().getName(), fine});
            otherTreasury.subtractOtherCosts(fine);
            int cashPerCity = fine / (this.map.getNumberCities() - 1);
            for (ICity city : this.map.getCities()) {
                if (city.equals(otherCity)) continue;
                Treasury treasury = (Treasury)this.findCityHall(city).getTreasury();
                treasury.addOtherIncome(cashPerCity);
            }
        }
        for (ch.sahits.game.openpatrician.model.city.cityhall.ICityHall cityHall : this.cityHalls) {
            ICitizen mayor = cityHall.getMayor();
            if (!(mayor instanceof IHumanPlayer)) continue;
            TargetedEvent displayMessage = new TargetedEvent((IHumanPlayer)mayor, (Object)msg);
            this.clientServerEventBus.post((Object)displayMessage);
        }
    }

    private void handleDeniedCityViolation(ICityViolation violation) {
        DisplayMessage msg = null;
        if (violation instanceof ICustomsViolation) {
            msg = new DisplayMessage("ch.sahits.game.openpatrician.engine.land.city.CityHallEngine.noSanctionsCustomViolation", new Object[]{violation.getCity().getName()});
        }
        if (violation instanceof IPirateSupportViolation) {
            msg = new DisplayMessage("ch.sahits.game.openpatrician.engine.land.city.CityHallEngine.noSanctionsPirateSupport", new Object[]{violation.getCity().getName()});
        }
        if (violation instanceof IPlunderTradingOfficesViolation) {
            msg = new DisplayMessage("ch.sahits.game.openpatrician.engine.land.city.CityHallEngine.noSanctionsPlunder", new Object[]{violation.getCity().getName()});
        }
        if (violation instanceof ISpecialTaxViolation) {
            msg = new DisplayMessage("ch.sahits.game.openpatrician.engine.land.city.CityHallEngine.noSanctionsSpecialTaxViolation", new Object[]{violation.getCity().getName()});
        }
        for (ch.sahits.game.openpatrician.model.city.cityhall.ICityHall cityHall : this.cityHalls) {
            ICitizen mayor = cityHall.getMayor();
            if (!(mayor instanceof IHumanPlayer)) continue;
            TargetedEvent displayMessage = new TargetedEvent((IHumanPlayer)mayor, (Object)msg);
            this.clientServerEventBus.post((Object)displayMessage);
        }
    }

    private void handleAcceptedCityPetition(ch.sahits.game.openpatrician.model.city.cityhall.ICityHall cityHall, ICityPetition petition) {
        if (petition instanceof ICityWallPetition) {
            ECityWall next;
            CityWall cityWall = cityHall.getCity().getCityState().getCityWall();
            if (cityWall.getExtension() == ECityWall.NOT_EXTENDED) {
                next = ECityWall.EXTENDED_ONCE;
                cityWall.setRequiredBricks(next.getRequiredBricks());
                cityWall.setBoughtBricks(0);
                cityWall.setUsedBricks(0);
                cityWall.setExtension(next);
            } else if (cityWall.getExtension() == ECityWall.EXTENDED_ONCE) {
                next = ECityWall.EXTENDED_TWICE;
                cityWall.setRequiredBricks(next.getRequiredBricks());
                cityWall.setBoughtBricks(0);
                cityWall.setUsedBricks(0);
                cityWall.setExtension(next);
            }
        }
        DisplayMessage msg = new DisplayMessage("ch.sahits.game.openpatrician.engine.land.city.CityHallEngine.yesCityWall", new Object[]{cityHall.getCity().getName()});
        if (petition instanceof IHeadTaxPetition) {
            double newTax = ((IHeadTaxPetition)petition).getNewTaxValue();
            msg = new DisplayMessage("ch.sahits.game.openpatrician.engine.land.city.CityHallEngine.yesHeadTax", new Object[]{cityHall.getCity().getName(), newTax});
            ((Treasury)cityHall.getTreasury()).setCurrentHeadTaxValue(newTax);
        }
        if (petition instanceof IMilitiaPetition) {
            msg = new DisplayMessage("ch.sahits.game.openpatrician.engine.land.city.CityHallEngine.yesMilitia", new Object[]{cityHall.getCity().getName()});
            ((CityHall)cityHall).setMaxNumberMilita(cityHall.getMaxNumberMilita() + 5);
        }
        if (petition instanceof ISpecialTaxPetition) {
            msg = this.leveySpecialTax(cityHall, (ISpecialTaxPetition)petition);
        }
        for (ICitizen citizen : cityHall.getCouncilmen()) {
            if (!(citizen instanceof IHumanPlayer)) continue;
            TargetedEvent displayMessage = new TargetedEvent((IHumanPlayer)citizen, (Object)msg);
            this.clientServerEventBus.post((Object)displayMessage);
        }
    }

    private DisplayMessage leveySpecialTax(final ch.sahits.game.openpatrician.model.city.cityhall.ICityHall cityHall, ISpecialTaxPetition petition) {
        int taxHeigth = petition.getTaxValue();
        DisplayMessage message = new DisplayMessage("ch.sahits.game.openpatrician.engine.land.city.CityHallEngine.yesSpecialTax", new Object[]{cityHall.getCity().getName(), taxHeigth});
        List players = cityHall.getCity().getResidentPlayers();
        long totalCashVolume = 0L;
        for (IPlayer player : players) {
            totalCashVolume += player.getCompany().getCash();
        }
        long collected = taxHeigth / 2;
        for (IPlayer player : players) {
            double percentage = (double)player.getCompany().getCash() * 1.0 / (double)totalCashVolume * 0.5;
            int amount = (int)((double)taxHeigth * percentage);
            if (player instanceof IAIPlayer) {
                player.getCompany().updateCash((long)(-amount));
                collected += (long)amount;
                continue;
            }
            ILoaner loaner = this.loanerService.findLoaner(cityHall.getCity());
            ICreditor creditor = new ICreditor(){

                public void receiveSum(long amount) {
                    ((Treasury)cityHall.getTreasury()).addPaidSpecialTaxes(amount);
                }
            };
            Debt debt = Debt.builder().loanTakeOut(this.date.getCurrentDate()).debitor((ICitizen)player).creditor(creditor).interest(0.0).amount(amount).dueDate(this.date.getCurrentDate().plusMonths(1)).build();
            loaner.addDebt((IDebt)debt);
        }
        ((Treasury)cityHall.getTreasury()).addPaidSpecialTaxes(collected);
        return message;
    }

    private void handleDeniedCityPetition(ch.sahits.game.openpatrician.model.city.cityhall.ICityHall cityHall, ICityPetition petition) {
        DisplayMessage msg = null;
        if (petition instanceof ICityWallPetition) {
            msg = new DisplayMessage("ch.sahits.game.openpatrician.engine.land.city.CityHallEngine.noPetitionCityWall", new Object[]{cityHall.getCity().getName()});
        }
        if (petition instanceof IHeadTaxPetition) {
            msg = new DisplayMessage("ch.sahits.game.openpatrician.engine.land.city.CityHallEngine.noPetitionHeadTax", new Object[]{cityHall.getCity().getName()});
        }
        if (petition instanceof IMilitiaPetition) {
            msg = new DisplayMessage("ch.sahits.game.openpatrician.engine.land.city.CityHallEngine.noPetitionMilitia", new Object[]{cityHall.getCity().getName()});
        }
        if (petition instanceof ISpecialTaxPetition) {
            msg = new DisplayMessage("ch.sahits.game.openpatrician.engine.land.city.CityHallEngine.noPetitionSpecialTax", new Object[]{cityHall.getCity().getName()});
        }
        for (ICitizen citizen : cityHall.getCouncilmen()) {
            if (!(citizen instanceof IHumanPlayer)) continue;
            TargetedEvent displayMessage = new TargetedEvent((IHumanPlayer)citizen, (Object)msg);
            this.clientServerEventBus.post((Object)displayMessage);
        }
    }

    private void initializeBlockadeAction(ICity city) {
    }

    @Subscribe
    public void handleMonthlyUpdate(PeriodicalTimeMonthEndUpdate event) {
        for (ch.sahits.game.openpatrician.model.city.cityhall.ICityHall cityHall : this.cityHalls) {
            this.handleMayoralTasks(cityHall);
            if (!cityHall.getAldermanOffice().isPresent()) continue;
            this.handleAldermansTask((IAldermanOffice)cityHall.getAldermanOffice().get());
        }
    }

    private void handleAldermansTask(IAldermanOffice office) {
        this.updateAldermanTasks(office);
    }

    private void updateAldermanTasks(IAldermanOffice office) {
        List tasks = office.getTasks();
        if (tasks.size() < 3) {
            Optional task;
            boolean helpTask = false;
            boolean newTown = false;
            boolean landPassage = false;
            boolean huntPirate = false;
            boolean capturePirateNest = false;
            ArrayList pirates = new ArrayList(this.pirateState.getFreePirates());
            Iterator iterator = tasks.iterator();
            while (iterator.hasNext()) {
                IAldermanTask task2 = (IAldermanTask)iterator.next();
                if (task2 instanceof IHelpCity) {
                    helpTask = true;
                    continue;
                }
                if (task2 instanceof IHuntPirate) {
                    if (!pirates.contains(((IHuntPirate)task2).getPirate())) {
                        iterator.remove();
                        continue;
                    }
                    huntPirate = true;
                    continue;
                }
                if (task2 instanceof IBuildLandPassage) {
                    landPassage = true;
                    continue;
                }
                if (task2 instanceof IFoundNewSettlement) {
                    newTown = true;
                    continue;
                }
                if (!(task2 instanceof ICapturePirateNest)) continue;
                capturePirateNest = true;
            }
            if (!helpTask && (task = this.stateFactory.createHelpCityAldermanTask(office)).isPresent()) {
                tasks.add(task.get());
            }
            if (tasks.size() < 3 && !huntPirate && (task = this.stateFactory.createPirateHuntEledermanTask(office)).isPresent()) {
                tasks.add(task.get());
            }
            if (tasks.size() < 3 && !landPassage && (task = this.stateFactory.createNewLandBridgeAldermanTask(office)).isPresent()) {
                tasks.add(task.get());
            }
            if (tasks.size() < 3 && !newTown && (task = this.stateFactory.createNewSettlementEledermanTask(office)).isPresent()) {
                tasks.add(task.get());
            }
            if (tasks.size() < 3 && !capturePirateNest && (task = this.stateFactory.createCapturePirateNestAldermanTask(office)).isPresent()) {
                tasks.add(task.get());
            }
        }
    }

    private void handleMayoralTasks(ch.sahits.game.openpatrician.model.city.cityhall.ICityHall cityHall) {
        int random;
        CityWall cityWall = cityHall.getCity().getCityState().getCityWall();
        boolean isHumanPlayer = this.isHumanPlayer(cityHall.getMayor());
        if (cityWall.getBoughtBricks() < cityWall.getRequiredBricks() && !isHumanPlayer) {
            random = this.rnd.nextInt(28);
            DateTime exection = this.date.getCurrentDate().plusDays(random);
            CityWallMaterialBuyingTask task = this.engineFactory.getCityWallBuyMaterialTask(cityHall, exection);
            this.timedTaskListener.add((TimedTask)task);
        }
        if (cityHall.getMaxNumberMilita() > cityHall.getCityGuard().size() && !isHumanPlayer && (random = this.rnd.nextInt(4)) == 0) {
            int[] guardNumbers = new int[]{this.countMilitia(cityHall.getCityGuard(), IBowmen.class), this.countMilitia(cityHall.getCityGuard(), IPikemen.class), this.countMilitia(cityHall.getCityGuard(), ICrossbowmen.class), this.countMilitia(cityHall.getCityGuard(), IMusketeer.class)};
            int whatIndex = 0;
            if (guardNumbers[0] > guardNumbers[1]) {
                whatIndex = 1;
            }
            if (guardNumbers[whatIndex] > guardNumbers[2]) {
                whatIndex = 2;
            }
            if (guardNumbers[whatIndex] > guardNumbers[3]) {
                whatIndex = 3;
            }
            Treasury treasury = (Treasury)cityHall.getTreasury();
            switch (whatIndex) {
                case 0: {
                    treasury.subtractCityGuardCosts(5);
                    IBowmen bowman = this.peopleFactory.createBowman();
                    cityHall.getCityGuard().add(bowman);
                    break;
                }
                case 1: {
                    treasury.subtractCityGuardCosts(5);
                    IPikemen pikeman = this.peopleFactory.createPikeman();
                    cityHall.getCityGuard().add(pikeman);
                    break;
                }
                case 2: {
                    treasury.subtractCityGuardCosts(10);
                    ICrossbowmen crossbowman = this.peopleFactory.createCrossbowman();
                    cityHall.getCityGuard().add(crossbowman);
                    break;
                }
                case 3: {
                    treasury.subtractCityGuardCosts(20);
                    IMusketeer musketeer = this.peopleFactory.createMusketeer();
                    cityHall.getCityGuard().add(musketeer);
                    break;
                }
                default: {
                    throw new IllegalStateException("Case " + whatIndex + " is not handled");
                }
            }
        }
    }

    private int countMilitia(List<ICityGuard> cityGuard, Class<? extends ICityGuard> clazz) {
        int count = 0;
        for (ICityGuard guard : cityGuard) {
            if (clazz == IBowmen.class && guard instanceof IBowmen) {
                ++count;
            }
            if (clazz == ICrossbowmen.class && guard instanceof ICrossbowmen) {
                ++count;
            }
            if (clazz == IPikemen.class && guard instanceof IPikemen) {
                ++count;
            }
            if (clazz != IMusketeer.class || !(guard instanceof IMusketeer)) continue;
            ++count;
        }
        return count;
    }

    @VisibleForTesting
    boolean isHumanPlayer(ICitizen mayor) {
        return mayor instanceof IHumanPlayer;
    }

    @Subscribe
    public void handleEndOfYearUpdate(PeriodicalTimeYearEndUpdate event) {
        for (ch.sahits.game.openpatrician.model.city.cityhall.ICityHall iCityHall : this.cityHalls) {
        }
    }

    @Override
    public List<AbstractEngine> getChildren() {
        return new ArrayList<AbstractEngine>();
    }

    public void establishCityHall(ICity city) {
        if (this.initialisation.initialisationHappened) {
            this.initializeCity(city);
        } else {
            this.initialisation.cities.add(city);
        }
    }

    private ch.sahits.game.openpatrician.model.city.cityhall.ICityHall initializeCity(ICity city) {
        ch.sahits.game.openpatrician.model.city.cityhall.ICityHall cityHall = this.stateFactory.createCityHall(city);
        return cityHall;
    }

    @Subscribe
    public void handleGameStartEvent(NewGameClient newGameClient) {
        this.initialisation.initialisationHappened = true;
        for (int i = 0; i < this.initialisation.cities.size(); ++i) {
            ICity city = (ICity)this.initialisation.cities.get(i);
            this.initializeCity(city);
        }
        for (ch.sahits.game.openpatrician.model.city.cityhall.ICityHall cityHall : this.cityHalls) {
            if (this.aldermanCandidates.size() >= 4) continue;
            this.aldermanCandidates.add(cityHall.getMayor());
        }
        ICitizen alderman = this.aldermanCandidates.get(this.rnd.nextInt(this.aldermanCandidates.size()));
        DateTime election = this.date.getCurrentDate().plusDays(this.rnd.nextInt(600));
        Optional task = this.stateFactory.createHelpCityAldermanTask();
        if (task.isPresent()) {
            this.aldermanOffice.getTasks().add(task.get());
        }
        for (ch.sahits.game.openpatrician.model.city.cityhall.ICityHall cityHall : this.cityHalls) {
            ((CityHall)cityHall).setAlderman(alderman);
            ((CityHall)cityHall).setAldermanElectionDate(election);
            if (!alderman.getHometown().equals(cityHall.getCity())) continue;
            Optional<AldermanOffice> office = Optional.of(this.aldermanOffice);
            ((CityHall)cityHall).setAldermanOffice(office);
        }
    }

    public ch.sahits.game.openpatrician.model.city.cityhall.ICityHall findCityHall(ICity city) {
        for (ch.sahits.game.openpatrician.model.city.cityhall.ICityHall cityHall : this.cityHalls) {
            ICity cityHallCity = cityHall.getCity();
            if (!cityHallCity.equals(city)) continue;
            return cityHall;
        }
        return null;
    }

    public void assignTask(IPlayer player, IAldermanTask task) {
        this.takenTasks.assignTask(player, task);
    }

    @VisibleForTesting
    void updateTreasuryWeekly(ch.sahits.game.openpatrician.model.city.cityhall.ICityHall cityHall) {
        Treasury treasury = (Treasury)cityHall.getTreasury();
        treasury.reset();
        ICity city = cityHall.getCity();
        if (cityHall.getOutriggerContract().isPresent()) {
            IOutriggerContract outriggerContract = (IOutriggerContract)cityHall.getOutriggerContract().get();
            int weeklyRefund = outriggerContract.getWeeklyRefund();
            treasury.subtractOutriggerCosts(weeklyRefund);
            IPlayer owner = (IPlayer)outriggerContract.getOutrigger().getOwner();
            owner.getCompany().updateCash((long)weeklyRefund);
        }
        int population = city.getPopulation(EPopulationClass.POOR);
        double taxes = (double)(population / 100) * this.weeklyHeadTaxPoor * treasury.getCurrentHeadTaxValue();
        population = city.getPopulation(EPopulationClass.MEDIUM);
        taxes += (double)(population / 100) * this.weeklyHeadTaxMiddleClass * treasury.getCurrentHeadTaxValue();
        population = city.getPopulation(EPopulationClass.RICH);
        taxes += (double)(population / 100) * this.weeklyHeadTaxRich * treasury.getCurrentHeadTaxValue();
        List residents = city.getResidentPlayers();
        long propertyTax = 0L;
        for (IPlayer resident : residents) {
            ICompany company = resident.getCompany();
            long cash = company.getCash();
            double weeklyPercentage = treasury.getCurrentHeadTaxValue() / 5200.0;
            long taxAmount = (long)((double)cash * weeklyPercentage);
            taxes += (double)taxAmount;
            List buildings = resident.findBuildings(city);
            long propertyTaxPerResedident = 0L;
            for (IBuilding building : buildings) {
                propertyTaxPerResedident = (long)((double)propertyTaxPerResedident + (double)building.getPropertyTax() * treasury.getCurrentPropertyTax());
            }
            propertyTax += propertyTaxPerResedident;
            company.updateCash(-(taxAmount + propertyTaxPerResedident));
            ICity hometown = resident.getHometown();
            BalanceSheet sheet = (BalanceSheet)resident.findTradingOffice(hometown).getCurrentWeek();
            sheet.deductPropertyTaxes((int)(taxAmount + propertyTaxPerResedident));
        }
        treasury.addPaidTaxes((long)taxes + propertyTax);
        List guards = cityHall.getCityGuard();
        int guardCosts = 0;
        for (ICityGuard guard : guards) {
            guardCosts += guard.getAmount() * guard.getWeeklySalary();
        }
        treasury.subtractCityGuardCosts(guardCosts);
    }

    public void checkPirateKilledAldermanTask(ShipAttackEvent event) {
        if (event.getAttackedShip().getOwner() instanceof ISeaPirate) {
            IAldermanOffice office = this.getAldermanOffice();
            Iterator iterator = office.getWorkedOnTasks().iterator();
            while (iterator.hasNext()) {
                IHuntPirate concreteTask;
                IAcceptedAldermanTask task = (IAcceptedAldermanTask)iterator.next();
                if (!(task.getTask() instanceof IHuntPirate) || !(concreteTask = (IHuntPirate)task.getTask()).getPirate().equals(event.getAttackedShip().getOwner())) continue;
                if (this.date.getCurrentDate().isBefore((ReadableInstant)task.getDeadline())) {
                    for (ICity iCity : this.map.getCities()) {
                        iCity.getReputation(task.getPlayer()).update(15);
                    }
                }
                iterator.remove();
            }
        }
    }

    private IAldermanOffice getAldermanOffice() {
        IAldermanOffice office = null;
        for (ch.sahits.game.openpatrician.model.city.cityhall.ICityHall cityHall : this.cityHalls) {
            if (!cityHall.getAldermanOffice().isPresent()) continue;
            office = (IAldermanOffice)cityHall.getAldermanOffice().get();
            break;
        }
        return office;
    }

    private static class CityInitialisation {
        private List<ICity> cities = new ArrayList<ICity>();
        private boolean initialisationHappened = false;

        private CityInitialisation() {
        }
    }
}

