/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player;

import ch.sahits.game.event.data.RepairFinishedEvent;
import ch.sahits.game.event.data.ai.HireSailorEvent;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.clientserverinterface.service.MapService;
import ch.sahits.game.openpatrician.engine.player.AggregatedBuyTradeStep;
import ch.sahits.game.openpatrician.engine.player.AggregatesDumpTradeStep;
import ch.sahits.game.openpatrician.engine.player.AggregatesSellTradeStep;
import ch.sahits.game.openpatrician.engine.player.CheckForRepairTradeStep;
import ch.sahits.game.openpatrician.engine.player.HireSailorsStep;
import ch.sahits.game.openpatrician.engine.player.TakeLoanTradeStep;
import ch.sahits.game.openpatrician.engine.player.TravelToTradeStep;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.model.player.IAITradeStrategy;
import ch.sahits.game.openpatrician.model.player.IAITradeStrategyType;
import ch.sahits.game.openpatrician.model.player.ICityProductionConsumptionKnowledge;
import ch.sahits.game.openpatrician.model.player.IProductionConsumptionKnowledge;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.ITradeStep;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import javafx.util.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public abstract class BasePlayerTradeStrategy
implements IAITradeStrategy {
    private final Logger logger = LogManager.getLogger(this.getClass());
    @Autowired
    private ApplicationContext context;
    @Autowired
    private IMap map;
    @Autowired
    @XStreamOmitField
    private MapService mapService;
    protected IAITradeStrategyType tradeStrategyType;

    protected boolean isMatchingTradeStrategy(IAIPlayer player) {
        return player.getTradeStrategyType().equals(this.tradeStrategyType);
    }

    public ITradeStep getNextStep(IAIPlayer player, INavigableVessel vessel) {
        return player.getNextTradeStep(vessel);
    }

    public boolean hasMoreTradeSteps(IAIPlayer player, INavigableVessel vessel) {
        return player.hasMoreTradeSteps(vessel);
    }

    public void append(IAIPlayer player, INavigableVessel vessel, ITradeStep step) {
        player.addTradeStep(step, vessel);
    }

    public void inject(IAIPlayer player, INavigableVessel vessel, ITradeStep step) {
        player.injectTradeStep(step, vessel);
    }

    public List<Pair<IWare, Number>> getMostNeededWares(ICityProductionConsumptionKnowledge knowledge) {
        Preconditions.checkNotNull((Object)knowledge, (Object)"The city production knowledge may not be null");
        ArrayList<Pair> need = new ArrayList<Pair>();
        for (EWare ware : EWare.values()) {
            int stored = knowledge.getStoredAmount((IWare)ware);
            int produced = knowledge.getProductionAmount((IWare)ware);
            int consumed = knowledge.getConsumptionAmount((IWare)ware);
            int value = consumed == 0 ? Integer.MAX_VALUE : stored + produced - consumed;
            need.add(new Pair((Object)ware, (Object)value));
        }
        return need.stream().sorted(new WareNeedComparator()).collect(Collectors.toList());
    }

    public boolean isNeeded(ICityProductionConsumptionKnowledge knowledge, IWare ware) {
        List<Pair<IWare, Number>> needs = this.getMostNeededWares(knowledge);
        for (Pair<IWare, Number> need : needs) {
            if (((IWare)need.getKey()).equals(ware) && ((Number)need.getValue()).intValue() < 10) {
                return true;
            }
            if (!((IWare)need.getKey()).equals(ware) && ((Number)need.getValue()).intValue() <= 10) continue;
            return false;
        }
        return false;
    }

    public List<Pair<IWare, Number>> getMostNeededWares(ICityProductionConsumptionKnowledge knowledge, INavigableVessel vessel) {
        List<Pair<IWare, Number>> sortedNeeds = this.getMostNeededWares(knowledge);
        ListIterator<Pair<IWare, Number>> iterator = sortedNeeds.listIterator();
        while (iterator.hasNext()) {
            Pair<IWare, Number> need = iterator.next();
            if (vessel.getWare((IWare)need.getKey()).getAmount() <= 0) continue;
            int value = ((Number)need.getValue()).intValue() + vessel.getWare((IWare)need.getKey()).getAmount();
            iterator.remove();
            iterator.add((Pair<IWare, Number>)new Pair(need.getKey(), (Object)value));
        }
        return sortedNeeds.stream().sorted(new WareNeedComparator()).collect(Collectors.toList());
    }

    protected List<IWare> getWaresNeedIn(IProductionConsumptionKnowledge knowledge, ICityProductionConsumptionKnowledge knowledgeCurrentTown, ICity nextStop) {
        ICityProductionConsumptionKnowledge knowledgeFirstTown = knowledge.getKnowlege(nextStop);
        List<Pair<IWare, Number>> sortedNeeds = this.getMostNeededWares(knowledgeFirstTown);
        ArrayList<IWare> deliverWare = new ArrayList<IWare>();
        for (Pair<IWare, Number> need : sortedNeeds) {
            if (knowledgeCurrentTown.getProductionAmount((IWare)need.getKey()) <= 0) continue;
            deliverWare.add((IWare)need.getKey());
        }
        return deliverWare;
    }

    protected ICity findNextStop(ICity baseTown, IProductionConsumptionKnowledge knowledge, List<IWare> waresOfInterest, ICity exclude) {
        List cities = knowledge.findListWithProductionsMinimalDistance(baseTown, waresOfInterest.get(0));
        if (((ICity)cities.get(0)).equals(exclude) && cities.size() > 1) {
            return (ICity)cities.get(1);
        }
        return (ICity)cities.get(0);
    }

    protected TravelToTradeStep createTravelToStep(INavigableVessel vessel, ICity travelToCity) {
        TravelToTradeStep travelTo = (TravelToTradeStep)this.context.getBean(TravelToTradeStep.class);
        travelTo.setDestinationCity(travelToCity);
        travelTo.setVessel(vessel);
        return travelTo;
    }

    protected CheckForRepairTradeStep createCheckRepairStep(INavigableVessel vessel, ICity city) {
        CheckForRepairTradeStep repairStep = (CheckForRepairTradeStep)this.context.getBean(CheckForRepairTradeStep.class);
        repairStep.setCity(city);
        repairStep.setVessel(vessel);
        return repairStep;
    }

    protected HireSailorsStep createHireSailorStep(INavigableVessel vessel, ICity city) {
        HireSailorsStep hireSailors = (HireSailorsStep)this.context.getBean(HireSailorsStep.class);
        hireSailors.setShip(vessel);
        hireSailors.setCity(city);
        return hireSailors;
    }

    protected TakeLoanTradeStep createCheckAndTakeLoanStep(IAIPlayer player, ICity city) {
        TakeLoanTradeStep takeLoan = (TakeLoanTradeStep)this.context.getBean(TakeLoanTradeStep.class);
        takeLoan.setCity(city);
        takeLoan.setPlayer(player);
        return takeLoan;
    }

    protected AggregatedBuyTradeStep createAggregatedBuyTradeStep(INavigableVessel vessel, ICity city, List<IWare> waresToBuy) {
        AggregatedBuyTradeStep buyStepHometown = (AggregatedBuyTradeStep)this.context.getBean(AggregatedBuyTradeStep.class);
        buyStepHometown.setCity(city);
        buyStepHometown.setVessel(vessel);
        buyStepHometown.setExecuteNext(true);
        for (IWare ware : waresToBuy) {
            int maxPrice = ware.getMaxBuyPriceOffensive();
            buyStepHometown.addBuyStep(ware, maxPrice);
        }
        return buyStepHometown;
    }

    protected AggregatesSellTradeStep createAggregatedSellStep(INavigableVessel vessel, ICity city, List<IWare> waresToSell) {
        AggregatesSellTradeStep sellStep = (AggregatesSellTradeStep)this.context.getBean(AggregatesSellTradeStep.class);
        sellStep.setVessel(vessel);
        sellStep.setCity(city);
        sellStep.setExecuteNext(true);
        for (IWare ware : waresToSell) {
            sellStep.addSellStep(ware);
        }
        return sellStep;
    }

    protected AggregatesDumpTradeStep createAggregatedDumpStep(INavigableVessel vessel, ICity city, List<IWare> waresToSell) {
        AggregatesDumpTradeStep sellStep = (AggregatesDumpTradeStep)this.context.getBean(AggregatesDumpTradeStep.class);
        sellStep.setVessel(vessel);
        sellStep.setCity(city);
        sellStep.setExecuteNext(true);
        for (IWare ware : waresToSell) {
            sellStep.addSellStep(ware);
        }
        return sellStep;
    }

    public boolean executeTradeSteps(IAIPlayer player, INavigableVessel vessel) {
        boolean proceedWithExecutionOfNextStep = true;
        if (this.hasMoreTradeSteps(player, vessel)) {
            try {
                this.logger.trace("Executed more steps for {} of {} {}", new Object[]{vessel.getName(), player.getName(), player.getLastName()});
                ITradeStep nextStep = this.getNextStep(player, vessel);
                this.logger.trace("Next step for {} of {} {}: {}", new Object[]{vessel.getName(), player.getName(), player.getLastName(), nextStep});
                if (nextStep.execute()) {
                    this.logger.trace("Execute recursive after " + nextStep.getClass().getName());
                    proceedWithExecutionOfNextStep = this.executeTradeSteps(player, vessel);
                }
                proceedWithExecutionOfNextStep = false;
                this.logger.trace("Do not execute any further steps after: {}", new Object[]{nextStep});
            }
            catch (IllegalStateException e) {
                throw e;
            }
            catch (RuntimeException e) {
                this.logger.error("Failed in execution of trade step for strategy: " + player.getTradeStrategyType() + " player " + player.getName() + " " + player.getLastName() + ", vessel: " + vessel.getName(), (Throwable)e);
            }
        } else {
            throw new IllegalStateException(String.format("There are no further steps defined for %s of %s %s for strategy %s", vessel.getName(), player.getName(), player.getLastName(), this.getClass().getName()));
        }
        player.updateTradeWaitingStatus(vessel, !proceedWithExecutionOfNextStep);
        return proceedWithExecutionOfNextStep;
    }

    protected void clearRemainingTradeSteps(INavigableVessel vessel, IAIPlayer player) {
        while (this.hasMoreTradeSteps(player, vessel)) {
            this.getNextStep(player, vessel);
        }
    }

    @Subscribe
    public void handleRepairFinished(RepairFinishedEvent event) {
        INavigableVessel vessel = event.getShip();
        IAIPlayer player = (IAIPlayer)vessel.getOwner();
        if (this.isMatchingTradeStrategy(player)) {
            Preconditions.checkArgument((boolean)this.hasMoreTradeSteps(player, vessel), (Object)("There most be steps defined after repair for " + vessel.getName() + " of " + player.getName() + " " + player.getLastName()));
            player.updateTradeWaitingStatus(vessel, false);
            this.executeTradeSteps(player, vessel);
        }
    }

    @Subscribe
    public void handleHireSailors(HireSailorEvent event) {
        INavigableVessel ship = event.getShip();
        ICity city = event.getCity();
        IAIPlayer player = (IAIPlayer)ship.getOwner();
        if (this.isMatchingTradeStrategy(player)) {
            HireSailorsStep hireSailor = this.createHireSailorStep(ship, city);
            this.inject(player, ship, hireSailor);
            this.executeTradeSteps(player, ship);
        }
    }

    protected List<IWare> getLoadedWares(INavigableVessel vessel) {
        return vessel.getLoadedWares().stream().filter(ware -> vessel.getWare(ware).getAmount() > 0).collect(Collectors.toList());
    }

    protected ArrayList<IWare> findWaresOfInterest(List<Pair<IWare, Number>> sortedNeeds) {
        ArrayList<IWare> waresOfInterest = new ArrayList<IWare>();
        for (Pair<IWare, Number> need : sortedNeeds) {
            if (((Number)need.getValue()).doubleValue() < 0.0 || waresOfInterest.isEmpty()) {
                waresOfInterest.add((IWare)need.getKey());
                continue;
            }
            if (waresOfInterest.size() >= 2) break;
            waresOfInterest.add((IWare)need.getKey());
        }
        return waresOfInterest;
    }

    private static class WareNeedComparator
    implements Comparator<Pair<IWare, Number>> {
        private WareNeedComparator() {
        }

        @Override
        public int compare(Pair<IWare, Number> firstPair, Pair<IWare, Number> secondPair) {
            return (int)Math.rint(((Number)firstPair.getValue()).doubleValue() - ((Number)secondPair.getValue()).doubleValue());
        }
    }
}

