/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.MapType;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.common.base.annotation.IgnoreOnDeserialisation;
import ch.sahits.game.openpatrician.model.player.ICityProductionConsumptionKnowledge;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;

@Prototype
@ClassCategory(value={EClassCategory.PROTOTYPE_BEAN, EClassCategory.SERIALIZABLE_BEAN})
public class CityProductionConsumptionKnowledge
implements ICityProductionConsumptionKnowledge {
    @MapType(key=IWare.class, value=Integer.class)
    private Map<IWare, Integer> productionAmounts = new HashMap<IWare, Integer>();
    @MapType(key=IWare.class, value=Integer.class)
    private Map<IWare, Integer> consumptionAmounts = new HashMap<IWare, Integer>();
    @MapType(key=IWare.class, value=Integer.class)
    private Map<IWare, Integer> storedAmounts = new HashMap<IWare, Integer>();

    @PostConstruct
    @IgnoreOnDeserialisation
    private void init() {
        for (EWare ware : EWare.values()) {
            if (this.storedAmounts.containsKey(ware)) continue;
            this.storedAmounts.put((IWare)ware, 0);
        }
    }

    public void updateProduction(IWare ware, int amount) {
        this.productionAmounts.put(ware, amount);
    }

    public List<IWare> getSortedProductionWares() {
        ArrayList<IWare> list = new ArrayList<IWare>();
        this.productionAmounts.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).forEach(entry -> list.add((IWare)entry.getKey()));
        return list;
    }

    public int getProductionAmount(IWare ware) {
        return this.productionAmounts.get(ware);
    }

    public void updateConsumption(IWare ware, int amount) {
        this.consumptionAmounts.put(ware, amount);
    }

    public int getConsumptionAmount(IWare ware) {
        return this.consumptionAmounts.get(ware);
    }

    public void updateStored(IWare ware, int amount) {
        this.storedAmounts.put(ware, amount);
    }

    public int getStoredAmount(IWare ware) {
        return this.storedAmounts.get(ware);
    }
}

