/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.clientserverinterface.service.LoanerService;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.ILoaner;
import ch.sahits.game.openpatrician.model.city.LoanerList;
import ch.sahits.game.openpatrician.model.city.impl.ILoanProposal;
import ch.sahits.game.openpatrician.model.player.IAITakeLoanStrategy;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class TakeLoanLowMoneyLongestDurationStrategy
implements IAITakeLoanStrategy {
    @Autowired
    private LoanerList loaners;
    @Autowired
    private LoanerService loanerService;

    public boolean shouldTakeLoan(IAIPlayer player) {
        long cash = player.getCompany().getCash();
        return cash < 5000L;
    }

    public void takeLoan(IAIPlayer player, ICity city) {
        ILoaner loaner = this.loanerService.findLoaner(city);
        List loans = loaner.getLoanProposals();
        ILoanProposal longest = null;
        for (ILoanProposal loan : loans) {
            if (longest == null) {
                longest = loan;
                continue;
            }
            if (loan.getDurationInWeeks() <= longest.getDurationInWeeks()) continue;
            longest = loan;
        }
        if (longest != null) {
            this.loanerService.takeOutLoan(loaner, longest, (IPlayer)player, city);
        }
    }
}

