/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.sea;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.clientserverinterface.model.PathInterpolatorMap;
import ch.sahits.game.openpatrician.clientserverinterface.model.VesselPositionUpdateData;
import ch.sahits.game.openpatrician.clientserverinterface.service.ShipService;
import ch.sahits.game.openpatrician.engine.sea.AStar;
import ch.sahits.game.openpatrician.engine.sea.IPathConverter;
import ch.sahits.game.openpatrician.engine.sea.model.ShipPositionUpdateTask;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.util.StartNewGameBean;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.geometry.Point2D;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
@Component
@Lazy
@DependentInitialisation(value=StartNewGameBean.class)
public class SeafaringService {
    private final Logger logger = LogManager.getLogger(this.getClass());
    @Autowired
    private AStar aStar;
    @Autowired
    @Qualifier(value="clientThreadPool")
    private ExecutorService clientThreadPool;
    @Autowired
    private ShipPositionUpdateTask shipUpdateTask;
    @Autowired
    private ShipService shipService;
    @Autowired
    private IPathConverter pathConverter;
    @Autowired
    @Qualifier(value="schedulableServerThreadPool")
    private ScheduledExecutorService schedulableServerThreadPool;
    @Autowired
    private PathInterpolatorMap interpolators;

    @PostConstruct
    private void initializeTimer() {
        this.schedulableServerThreadPool.scheduleAtFixedRate((Runnable)((Object)this.shipUpdateTask), 0L, 100L, TimeUnit.MILLISECONDS);
    }

    public List<Point2D> travelTo(INavigableVessel vessel, Point2D destination) {
        Point2D source = vessel.getLocation();
        Preconditions.checkArgument((!source.equals((Object)destination) ? 1 : 0) != 0, (Object)"Destination and source may not be the same");
        Future<List> future = this.clientThreadPool.submit(() -> this.aStar.findPath(source, destination));
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            this.logger.warn("Failed to execute path finding in separate thread from " + source + " to " + destination + " of " + vessel.getName() + " by " + vessel.getOwner().getName() + " " + vessel.getOwner().getLastName() + ".", (Throwable)e);
            e.printStackTrace();
            return this.aStar.findPath(source, destination);
        }
    }

    public void travelBetweenCities(INavigableVessel vessel, ICity toCity) {
        List<Point2D> path = this.travelTo(vessel, toCity.getCoordinates());
        this.pathConverter.createPath(vessel, path, 1.0);
        VesselPositionUpdateData vesselPositionUpdateData = this.interpolators.get((Object)vessel);
        vesselPositionUpdateData.setDestinationCity(true);
        vesselPositionUpdateData.setSourceCity(true);
    }

    public void travelToCity(INavigableVessel vessel, ICity toCity) {
        List<Point2D> path = this.travelTo(vessel, toCity.getCoordinates());
        this.pathConverter.createPath(vessel, path, 1.0);
        VesselPositionUpdateData vesselPositionUpdateData = this.interpolators.get((Object)vessel);
        vesselPositionUpdateData.setDestinationCity(true);
        vesselPositionUpdateData.setSourceCity(false);
    }

    public void travelNotBetweenCities(INavigableVessel vessel, Point2D location) {
        List<Point2D> path = this.travelTo(vessel, location);
        this.pathConverter.createPath(vessel, path, 1.0);
        VesselPositionUpdateData vesselPositionUpdateData = this.interpolators.get((Object)vessel);
        vesselPositionUpdateData.setDestinationCity(false);
        vesselPositionUpdateData.setSourceCity(false);
    }

    public void travelFromCity(INavigableVessel vessel, Point2D location) {
        List<Point2D> path = this.travelTo(vessel, location);
        this.pathConverter.createPath(vessel, path, 1.0);
        VesselPositionUpdateData vesselPositionUpdateData = this.interpolators.get((Object)vessel);
        vesselPositionUpdateData.setDestinationCity(false);
        vesselPositionUpdateData.setSourceCity(true);
    }
}

